<?php $__env->startSection('title', 'Frequently Asked Questions - The LaLiT Hotels'); ?>
<?php $__env->startSection('meta_description', 'Find answers to frequently asked questions about The LaLiT Hotels membership program, bookings, and services.'); ?>
<?php $__env->startSection('meta_keywords', 'FAQ, frequently asked questions, The LaLiT Hotels, membership, booking, support'); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-5">
    <!-- Header Section -->
    <section class="text-center mb-5 pt-lg-3 pt-md-4">
        <h1 class="display-4 fw-bold">Frequently Asked Questions</h1>
        <div class="lead mt-3 mb-5 w-75 mx-auto">
            Find answers to the most commonly asked questions about The LaLiT Hotels membership program, services, and booking process.
        </div>
    </section>

    <?php if($faqsByCategory->count() > 0): ?>
        <!-- FAQ Categories Navigation -->
        <?php if($faqsByCategory->count() > 1): ?>
        <section class="mb-5">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="faq-categories text-center">
                        <h6 class="text-muted mb-3">Quick Navigation</h6>
                        <?php $__currentLoopData = $faqsByCategory->keys(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="#category-<?php echo e(Str::slug($category)); ?>" class="btn btn-outline-primary btn-sm me-2 mb-2">
                                <?php echo e($category); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>

        <!-- FAQ Sections -->
        <?php $__currentLoopData = $faqsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryFaqs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <section class="mb-5" id="category-<?php echo e(Str::slug($category)); ?>">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <?php if($faqsByCategory->count() > 1): ?>
                    <h2 class="section-title text-center mb-4"><?php echo e($category); ?></h2>
                    <div class="header-title-line mb-5" style="margin: 0 auto;"></div>
                    <?php endif; ?>
                    
                    <div class="custom-accordion" id="accordion-<?php echo e(Str::slug($category)); ?>">
                        <?php $__currentLoopData = $categoryFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header" onclick="toggleAccordion(<?php echo e($faq->id); ?>)">
                                <h3 class="custom-accordion-title">
                                    <?php echo e($faq->question); ?>

                                    <i class="fas fa-chevron-down custom-accordion-icon" id="icon-<?php echo e($faq->id); ?>"></i>
                                </h3>
                            </div>
                            <div class="custom-accordion-content <?php echo e($index === 0 ? 'active' : ''); ?>" id="content-<?php echo e($faq->id); ?>">
                                <div class="custom-accordion-body">
                                    <?php echo $faq->answer; ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Contact Section -->
        <section class="pt-0 pb-0 text-center">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <h3 class="section-title mb-3">Still Have Questions?</h3>
                    <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
                    <p class="section-subtitle mb-4">
                        Can't find the answer you're looking for? Our customer support team is here to help you.
                    </p>
                    <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
                        <a href="<?php echo e(route('pages.contact')); ?>" class="btn btn-lg btn-lalit">
                            Contact Support
                        </a>
                    </div>
                </div>
            </div>
        </section>
    <?php else: ?>
        <!-- Empty State -->
        <section class="py-5 text-center">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <i class="fas fa-question-circle fa-4x text-muted mb-4"></i>
                    <h3 class="mb-3">No FAQs Available</h3>
                    <p class="text-muted mb-4">
                        We're working on adding frequently asked questions. Please check back soon or contact our support team for assistance.
                    </p>
                    <a href="<?php echo e(route('pages.contact')); ?>" class="btn btn-lg cta-btn-white">
                        Contact Support
                    </a>
                </div>
            </div>
        </section>
    <?php endif; ?>
</div>

<script>
function toggleAccordion(faqId) {
    const content = document.getElementById('content-' + faqId);
    const icon = document.getElementById('icon-' + faqId);
    const header = content.previousElementSibling;
    
    // Close all other accordion items in the same accordion group
    const accordionGroup = content.closest('.custom-accordion');
    const allContents = accordionGroup.querySelectorAll('.custom-accordion-content');
    const allIcons = accordionGroup.querySelectorAll('.custom-accordion-icon');
    const allHeaders = accordionGroup.querySelectorAll('.custom-accordion-header');
    
    allContents.forEach((item, index) => {
        if (item !== content) {
            item.classList.remove('active');
            allIcons[index].classList.remove('rotated');
            allHeaders[index].classList.remove('active');
        }
    });
    
    // Toggle current item
    content.classList.toggle('active');
    icon.classList.toggle('rotated');
    header.classList.toggle('active');
}

// Initialize first item as open
document.addEventListener('DOMContentLoaded', function() {
    const firstItems = document.querySelectorAll('.custom-accordion .custom-accordion-item:first-child');
    firstItems.forEach(item => {
        const header = item.querySelector('.custom-accordion-header');
        const content = item.querySelector('.custom-accordion-content');
        const icon = item.querySelector('.custom-accordion-icon');
        
        if (content.classList.contains('active')) {
            header.classList.add('active');
            icon.classList.add('rotated');
        }
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/faqs.blade.php ENDPATH**/ ?>