

<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Member Details</h1>
                    <div>
                        <a href="<?php echo e(route('admin.members.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                        <form action="<?php echo e(route('admin.members.destroy', $member)); ?>" 
                              method="POST" 
                              class="d-inline"
                              onsubmit="return confirm('Are you sure you want to delete this member? This action cannot be undone.')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash"></i> Delete Member
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Member Information -->
                <div class="row">
                    <!-- Personal Information -->
                    <div class="col-md-6 mb-4">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0"><i class="fas fa-user me-2"></i>Personal Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">Member Number:</th>
                                        <td><code><?php echo e($member->member_number ?? 'N/A'); ?></code></td>
                                    </tr>
                                    <tr>
                                        <th>API Member ID:</th>
                                        <td><code><?php echo e($member->api_member_id ?? 'N/A'); ?></code></td>
                                    </tr>
                                    <tr>
                                        <th>Full Name:</th>
                                        <td>
                                            <strong><?php echo e($member->title); ?> <?php echo e($member->full_name); ?></strong>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Email:</th>
                                        <td>
                                            <?php echo e($member->email); ?>

                                            <?php if($member->email_verified): ?>
                                                <i class="fas fa-check-circle text-success ms-1" title="Verified"></i>
                                            <?php else: ?>
                                                <i class="fas fa-times-circle text-danger ms-1" title="Not Verified"></i>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Mobile:</th>
                                        <td>
                                            <?php echo e($member->mobile ?? 'N/A'); ?>

                                            <?php if($member->mobile_verified): ?>
                                                <i class="fas fa-check-circle text-success ms-1" title="Verified"></i>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Date of Birth:</th>
                                        <td><?php echo e($member->date_of_birth ? $member->date_of_birth->format('F d, Y') : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Gender:</th>
                                        <td><?php echo e($member->gender ? ucfirst($member->gender) : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Nationality:</th>
                                        <td><?php echo e($member->nationality ?? 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Membership Information -->
                    <div class="col-md-6 mb-4">
                        <div class="card h-100">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-id-card me-2"></i>Membership Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">Status:</th>
                                        <td>
                                            <?php if($member->status === 'active'): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php elseif($member->status === 'inactive'): ?>
                                                <span class="badge bg-secondary">Inactive</span>
                                            <?php elseif($member->status === 'suspended'): ?>
                                                <span class="badge bg-danger">Suspended</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?php echo e(ucfirst($member->status)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Tier:</th>
                                        <td>
                                            <?php if($member->tier): ?>
                                                <span class="badge bg-info"><?php echo e(ucfirst($member->tier)); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Points:</th>
                                        <td><strong><?php echo e(number_format($member->points ?? 0)); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Enrollment Date:</th>
                                        <td><?php echo e($member->enrollment_date ? $member->enrollment_date->format('F d, Y') : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Enrollment Channel:</th>
                                        <td><?php echo e($member->enrollment_channel ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Marketing Opt-in:</th>
                                        <td>
                                            <?php if($member->marketing_opt_in): ?>
                                                <span class="badge bg-success">Yes</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">No</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Last Login:</th>
                                        <td><?php echo e($member->last_login_at ? $member->last_login_at->format('M d, Y h:i A') : 'Never'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Last Synced:</th>
                                        <td><?php echo e($member->last_synced_at ? $member->last_synced_at->format('M d, Y h:i A') : 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Address Information -->
                    <div class="col-md-12 mb-4">
                        <div class="card">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0"><i class="fas fa-map-marker-alt me-2"></i>Address Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="20%">Address Line 1:</th>
                                        <td><?php echo e($member->address_line1 ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Address Line 2:</th>
                                        <td><?php echo e($member->address_line2 ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>City:</th>
                                        <td><?php echo e($member->city ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>State/Region:</th>
                                        <td><?php echo e($member->state ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Country:</th>
                                        <td><?php echo e($member->country ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Postal Code:</th>
                                        <td><?php echo e($member->postal_code ?? 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Tier Data (if exists) -->
                    <?php if($member->tier_data && is_array($member->tier_data) && count($member->tier_data) > 0): ?>
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-warning text-dark">
                                <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Tier Data</h5>
                            </div>
                            <div class="card-body">
                                <pre class="mb-0 bg-light p-3 rounded"><?php echo e(json_encode($member->tier_data, JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Balances (if exists) -->
                    <?php if($member->balances && is_array($member->balances) && count($member->balances) > 0): ?>
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-wallet me-2"></i>Balances</h5>
                            </div>
                            <div class="card-body">
                                <pre class="mb-0 bg-light p-3 rounded"><?php echo e(json_encode($member->balances, JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- System Information -->
                    <div class="col-md-12 mb-4">
                        <div class="card">
                            <div class="card-header bg-secondary text-white">
                                <h5 class="mb-0"><i class="fas fa-database me-2"></i>System Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="20%">Created At:</th>
                                        <td><?php echo e($member->created_at->format('F d, Y h:i A')); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Updated At:</th>
                                        <td><?php echo e($member->updated_at->format('F d, Y h:i A')); ?></td>
                                    </tr>
                                    <?php if($member->deleted_at): ?>
                                    <tr>
                                        <th>Deleted At:</th>
                                        <td class="text-danger"><?php echo e($member->deleted_at->format('F d, Y h:i A')); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th>Has Valid Token:</th>
                                        <td>
                                            <?php if($member->hasValidToken()): ?>
                                                <span class="badge bg-success">Yes</span>
                                                <small class="text-muted">(Expires: <?php echo e($member->token_expires_at->format('M d, Y h:i A')); ?>)</small>
                                            <?php else: ?>
                                                <span class="badge bg-danger">No</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .table th {
        font-weight: 600;
        color: #6c757d;
    }
    code {
        background-color: #f8f9fa;
        padding: 2px 6px;
        border-radius: 3px;
        color: #d63384;
        font-size: 0.9em;
    }
    pre {
        font-size: 0.85em;
        max-height: 300px;
        overflow-y: auto;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/admin/members/show.blade.php ENDPATH**/ ?>