<?php $__env->startSection('title', 'Edit Profile - The LaLiT Loyalty'); ?>

<?php $__env->startPush('styles'); ?>
  <!-- Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
  <style>
    /* Custom Select2 styling for preferences tab */
    .select2-container--bootstrap-5 .select2-selection {
      min-height: 38px;
      border-color: #dee2e6;
    }
    
    /* Multiple select styling */
    .select2-container--bootstrap-5 .select2-selection--multiple {
      min-height: 38px;
      padding: 2px 8px;
    }
    
    .select2-container--bootstrap-5 .select2-selection--multiple .select2-selection__choice {
      background-color: #f5f0eb;
      border: 1px solid #212529;
      border-radius: 4px;
      color: #fff;
      padding: 2px 8px;
      margin: 2px 4px 2px 0;
      font-size: 14px;
    }
    
    .select2-container--bootstrap-5 .select2-selection--multiple .select2-selection__choice__remove {
      color: #fff;
      margin-right: 5px;
      font-weight: bold;
    }
    
    .select2-container--bootstrap-5 .select2-selection--multiple .select2-selection__choice__remove:hover {
      color: #fff;
      background-color: transparent;
    }
    
    .select2-container--bootstrap-5.select2-container--focus .select2-selection,
    .select2-container--bootstrap-5.select2-container--open .select2-selection {
      border-color: #212529;
      box-shadow: 0 0 0 0.25rem rgba(33, 37, 41, 0.25);
    }
    
    /* Dropdown styling */
    .select2-container--bootstrap-5 .select2-dropdown {
      border-color: #dee2e6;
    }
    
    .select2-container--bootstrap-5 .select2-results__option--highlighted {
      background-color: #212529;
      color: #fff;
    }
  </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
  <div class="container px-4 py-5 edit-profile">
    <div class="row justify-content-center">
      <div class="col-lg-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-5">
          <div class="flex-grow-1">
            <h2 class="mb-2 edit-profile-header">A place to update your details</h2>
          </div>
          <div>
            <a href="<?php echo e(route('membership.dashboard')); ?>" class="btn back-to-dashboard-btn">
              <i class="fas fa-arrow-left me-2"></i>BACK TO DASHBOARD
            </a>
          </div>
        </div>

        <?php if(session('status')): ?>
          <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <?php echo e(session('status')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <strong>Please correct the following errors:</strong>
            <ul class="mb-0 mt-2">
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <?php endif; ?>

        <!-- Tab Navigation -->
        <div class="mb-4">
          <ul class="nav nav-tabs justify-content-center border-0 edit-profile-tabs" id="profileTabs" role="tablist">
            <li class="nav-item" role="presentation">
              <button class="nav-link active px-0 border-0 bg-transparent text-uppercase fw-normal edit-profile-tab-link"
                id="personal-tab" data-bs-toggle="tab" data-bs-target="#personal" type="button" role="tab"
                aria-controls="personal" aria-selected="true">
                PROFILE
              </button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link px-0 border-0 bg-transparent text-uppercase fw-normal edit-profile-tab-link"
                id="preferences-tab" data-bs-toggle="tab" data-bs-target="#preferences" type="button" role="tab"
                aria-controls="preferences" aria-selected="false">
                PREFERENCES
              </button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link px-0 border-0 bg-transparent text-uppercase fw-normal edit-profile-tab-link"
                id="password-tab" data-bs-toggle="tab" data-bs-target="#password" type="button" role="tab"
                aria-controls="password" aria-selected="false">
                CHANGE PASSWORD
              </button>
            </li>
          </ul>
        </div>

        <!-- Tab Content -->
        <div class="tab-content" id="profileTabContent">
          <!-- Personal Details Tab -->
          <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <p class="text-muted mb-4 edit-profile-disclaimer">All fields are mandatory unless stated otherwise.</p>

                <h5 class="mb-4 edit-profile-section-title">Personal Information</h5>

                <form method="POST" action="<?php echo e(route('membership.update-profile')); ?>">
                  <?php echo csrf_field(); ?>

                  <div class="row mb-3">
                    <div class="col-md-4">
                      <label for="title" class="form-label text-uppercase edit-profile-form-label">TITLE (required)</label>
                      <select class="form-select" id="title" name="title" required>
                        <option value="">Select</option>
                        <option value="MR" <?php echo e((old('title', $member->title ?? '') == 'MR') ? 'selected' : ''); ?>>Mr</option>
                        <option value="Mrs." <?php echo e((old('title', $member->title ?? '') == 'Mrs.') ? 'selected' : ''); ?>>Mrs
                        </option>
                        <option value="Ms." <?php echo e((old('title', $member->title ?? '') == 'Ms.') ? 'selected' : ''); ?>>Ms
                        </option>
                        <option value="DR" <?php echo e((old('title', $member->title ?? '') == 'DR') ? 'selected' : ''); ?>>Dr</option>
                      </select>
                      <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="title-error" class="text-danger small mt-1" style="display: none;"></div>
                    </div>
                    <div class="col-md-4">
                      <label for="first_name" class="form-label text-uppercase edit-profile-form-label">FIRST NAME (required)</label>
                      <input type="text" class="form-control" id="first_name" name="first_name"
                        value="<?php echo e(old('first_name', $member->first_name ?? $user->name ?? '')); ?>" required>
                      <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="first_name-error" class="text-danger small mt-1" style="display: none;"></div>
                    </div>
                    <div class="col-md-4">
                      <label for="last_name" class="form-label text-uppercase edit-profile-form-label">LAST NAME (required)</label>
                      <input type="text" class="form-control" id="last_name" name="last_name"
                        value="<?php echo e(old('last_name', $member->last_name ?? '')); ?>" required>
                      <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="last_name-error" class="text-danger small mt-1" style="display: none;"></div>
                    </div>
                  </div>

                  <div class="row mb-3">
                    <div class="col-md-4">
                      <label for="middle_name" class="form-label text-uppercase edit-profile-form-label">MIDDLE NAME
                        (OPTIONAL)</label>
                      <input type="text" class="form-control" id="middle_name" name="middle_name"
                        value="<?php echo e(old('middle_name', $member->middle_name ?? '')); ?>">
                    </div>
                    <div class="col-md-4">
                      <label for="nationality" class="form-label text-uppercase edit-profile-form-label">NATIONALITY
                        (OPTIONAL)</label>
                      <select class="form-select" id="nationality" name="nationality">
                        <option value="">Select</option>
                        <option value="INDIA" <?php echo e((old('nationality', $member->nationality ?? '') == 'INDIA') ? 'selected' : ''); ?>>Indian</option>
                      </select>
                    </div>
                    <div class="col-md-4">
                      <label for="email" class="form-label text-uppercase edit-profile-form-label">EMAIL (required)</label>
                      <input type="email" class="form-control" id="email" name="email"
                        value="<?php echo e(old('email', $member->email ?? $user->email ?? '')); ?>" required>
                      <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="email-error" class="text-danger small mt-1" style="display: none;"></div>
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-4">
                      <label for="date_of_birth" class="form-label text-uppercase edit-profile-form-label">DATE OF BIRTH
                        (OPTIONAL)</label>
                      <input type="date" class="form-control" id="date_of_birth" name="date_of_birth"
                        value="<?php echo e(old('date_of_birth', $member && $member->date_of_birth ? $member->date_of_birth->format('Y-m-d') : '')); ?>"
                        max="<?php echo e(date('Y-m-d')); ?>">
                    </div>
                    <div class="col-md-4">
                      <label for="gender" class="form-label text-uppercase edit-profile-form-label">GENDER
                        (OPTIONAL)</label>
                      <select class="form-select" id="gender" name="gender">
                        <option value="">Select</option>
                        <option value="male" <?php echo e((old('gender', $member->gender ?? '') == 'male') ? 'selected' : ''); ?>>Male
                        </option>
                        <option value="female" <?php echo e((old('gender', $member->gender ?? '') == 'female') ? 'selected' : ''); ?>>
                          Female</option>
                        <option value="other" <?php echo e((old('gender', $member->gender ?? '') == 'other') ? 'selected' : ''); ?>>
                          Other</option>
                      </select>
                    </div>
                    <div class="col-md-4">
                      <label for="mobile" class="form-label text-uppercase edit-profile-form-label">MOBILE
                        </label>
                      <input disabled type="tel" class="form-control" id="mobile" name="mobile"
                        value="<?php echo e(old('mobile', $member->mobile ?? '')); ?>">
                    </div>
                  </div>

                  <?php
                    // Parse extra_data JSON to get preference values
                    $extraData = [];
                    if ($member && $member->extra_data) {
                      $extraData = is_string($member->extra_data) ? json_decode($member->extra_data, true) : $member->extra_data;
                    }
                    
                    $weddingAnniversary = old('marriage_anniversary', $extraData['wedding_anniversary'] ?? '');
                    $company = old('company', $extraData['company'] ?? '');
                    $jobTitle = old('designation', $extraData['job_title'] ?? '');
                  ?>

                  <div class="row mb-4">
                    <div class="col-md-4">
                      <label for="marriage_anniversary" class="form-label text-uppercase edit-profile-form-label">
                        MARRIAGE ANNIVERSARY (OPTIONAL)
                      </label>
                      <input type="date" class="form-control" id="marriage_anniversary" name="marriage_anniversary"
                        value="<?php echo e($weddingAnniversary); ?>" max="<?php echo e(date('Y-m-d')); ?>">
                      <?php $__errorArgs = ['marriage_anniversary'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-4">
                      <label for="company" class="form-label text-uppercase edit-profile-form-label">
                        COMPANY (OPTIONAL)
                      </label>
                      <input type="text" class="form-control" id="company" name="company"
                        value="<?php echo e($company); ?>" placeholder="Enter company name">
                      <?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-4">
                      <label for="designation" class="form-label text-uppercase edit-profile-form-label">
                        DESIGNATION (OPTIONAL)
                      </label>
                      <select class="form-select" id="designation" name="designation">
                        <option value="">Select Designation</option>
                        <option value="ARC" <?php echo e($jobTitle == 'ARC' ? 'selected' : ''); ?>>Architect</option>
                        <option value="CEO" <?php echo e($jobTitle == 'CEO' ? 'selected' : ''); ?>>CEO</option>
                        <option value="CFO" <?php echo e($jobTitle == 'CFO' ? 'selected' : ''); ?>>CFO</option>
                        <option value="CTO" <?php echo e($jobTitle == 'CTO' ? 'selected' : ''); ?>>CTO</option>
                        <option value="EDU" <?php echo e($jobTitle == 'EDU' ? 'selected' : ''); ?>>EDUCATOR</option>
                        <option value="MANAGER" <?php echo e($jobTitle == 'MANAGER' ? 'selected' : ''); ?>>Manager</option>
                        <option value="PM" <?php echo e($jobTitle == 'PM' ? 'selected' : ''); ?>>Product Manager</option>
                        <option value="PRM" <?php echo e($jobTitle == 'PRM' ? 'selected' : ''); ?>>Project Manager</option>
                        <option value="SDE" <?php echo e($jobTitle == 'SDE' ? 'selected' : ''); ?>>Software Developer</option>
                      </select>
                      <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <h5 class="mb-4 mt-5 edit-profile-section-title">Address Information</h5>

                  <div class="row mb-3">
                    <div class="col-md-6">
                      <label for="address_line_1" class="form-label text-uppercase edit-profile-form-label">ADDRESS LINE 1
                        / P.O. BOX (OPTIONAL)</label>
                      <input type="text" class="form-control" id="address_line_1" name="address_line_1"
                        value="<?php echo e(old('address_line_1', $member->address_line1 ?? '')); ?>">
                    </div>
                    <div class="col-md-6">
                      <label for="address_line_2" class="form-label text-uppercase edit-profile-form-label">ADDRESS LINE 2
                        (OPTIONAL)</label>
                      <input type="text" class="form-control" id="address_line_2" name="address_line_2"
                        value="<?php echo e(old('address_line_2', $member->address_line2 ?? '')); ?>">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <div class="col-md-6">
                      <label for="country" class="form-label text-uppercase edit-profile-form-label">COUNTRY OF
                        RESIDENCE (required)</label>
                      <select class="form-select" id="country" name="country" required>
                        <option value="">Select Country</option>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($country->country_id); ?>" <?php echo e((old('country', $member->country ?? '') == $country->country_id) ? 'selected' : ''); ?> data-country-name="<?php echo e($country->name); ?>">
                            <?php echo e($country->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                      <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="country-error" class="text-danger small mt-1" style="display: none;"></div>
                    </div>
                    <div class="col-md-6">
                      <label for="state" class="form-label text-uppercase edit-profile-form-label">STATE / REGION (required)</label>
                      <select class="form-select" id="state" name="state" required>
                        <option value="">Select State/Region</option>
                      </select>
                      <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="state-error" class="text-danger small mt-1" style="display: none;"></div>
                      <input type="hidden" id="region_id" name="region_id" value="">
                      <input type="hidden" id="region_name" name="region_name" value="">
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="city" class="form-label text-uppercase edit-profile-form-label">CITY (required)</label>
                      <select class="form-select" id="city" name="city" required>
                        <option value="">Select City</option>
                      </select>
                      <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      <div id="city-error" class="text-danger small mt-1" style="display: none;"></div>
                      <input type="hidden" id="city_id" name="city_id" value="">
                      <input type="hidden" id="city_name" name="city_name" value="">
                    </div>
                    <div class="col-md-6">
                      <label for="postal_code" class="form-label text-uppercase edit-profile-form-label">ZIP / POST CODE
                        (OPTIONAL)</label>
                      <input type="text" class="form-control" id="postal_code" name="postal_code"
                        value="<?php echo e(old('postal_code', $member->postal_code ?? '')); ?>" pattern="[0-9]{6}" maxlength="6"
                        placeholder="Enter 6-digit postal code">
                    </div>
                  </div>

                  <div class="text-center">
                    <button type="submit" class="btn btn-dark px-5 py-2 text-uppercase edit-profile-save-btn">
                      SAVE CHANGES
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <!-- Preferences Tab -->
          <div class="tab-pane fade" id="preferences" role="tabpanel" aria-labelledby="preferences-tab">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h5 class="mb-4 edit-profile-section-title">Preferences</h5>
                <p class="text-muted mb-4">Additional information to personalize your experience.</p>

                <!-- Success/Error Alerts -->
                <div id="preferencesSuccess" class="alert alert-success alert-dismissible fade show d-none" role="alert">
                  <i class="fas fa-check-circle me-2"></i>
                  <span id="preferencesSuccessMessage"></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>

                <div id="preferencesError" class="alert alert-danger alert-dismissible fade show d-none" role="alert">
                  <i class="fas fa-exclamation-circle me-2"></i>
                  <span id="preferencesErrorMessage"></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>

                <?php
                  // Parse extra_data JSON to get preference values
                  $extraData = [];
                  if ($member && $member->extra_data) {
                    $extraData = is_string($member->extra_data) ? json_decode($member->extra_data, true) : $member->extra_data;
                  }
                  
                  // Single-value fields
                  $travellerType = old('traveller_type', $extraData['traveller'] ?? '');
                  $beveragePreference = old('beverage_preference', $extraData['beverage_preference'] ?? '');
                  $spiceLevel = old('spice_level', $extraData['spice'] ?? '');
                  
                  // Multi-value fields - ensure they are arrays
                  $frequentCities = old('frequent_cities', $extraData['frequent_city'] ?? []);
                  $frequentCities = is_array($frequentCities) ? $frequentCities : (empty($frequentCities) ? [] : [$frequentCities]);
                  
                  $roomPreference = old('room_preference', $extraData['room'] ?? []);
                  $roomPreference = is_array($roomPreference) ? $roomPreference : (empty($roomPreference) ? [] : [$roomPreference]);
                  
                  $favouriteCuisine = old('favourite_cuisine', $extraData['favorite_food'] ?? []);
                  $favouriteCuisine = is_array($favouriteCuisine) ? $favouriteCuisine : (empty($favouriteCuisine) ? [] : [$favouriteCuisine]);
                  
                  $pillowPreference = old('pillow_preference', $extraData['pillow'] ?? []);
                  $pillowPreference = is_array($pillowPreference) ? $pillowPreference : (empty($pillowPreference) ? [] : [$pillowPreference]);
                  
                  $roomShouldBe = old('room_should_be', $extraData['floor'] ?? []);
                  $roomShouldBe = is_array($roomShouldBe) ? $roomShouldBe : (empty($roomShouldBe) ? [] : [$roomShouldBe]);
                  
                  $dietaryPreference = old('dietary_preference', $extraData['dietary_preference'] ?? []);
                  $dietaryPreference = is_array($dietaryPreference) ? $dietaryPreference : (empty($dietaryPreference) ? [] : [$dietaryPreference]);
                  
                  $allergies = old('allergies', $extraData['allergy'] ?? []);
                  $allergies = is_array($allergies) ? $allergies : (empty($allergies) ? [] : [$allergies]);
                ?>

                <form id="updatePreferencesForm" method="PUT" action="<?php echo e(route('membership.update-preferences')); ?>">
                  <?php echo csrf_field(); ?>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="traveller_type" class="form-label text-uppercase edit-profile-form-label">
                        Traveller type
                      </label>
                      <select class="form-select" id="traveller_type" name="traveller_type">
                        <option value="">Select</option>
                        <option value="BIZ" <?php echo e($travellerType == 'BIZ' ? 'selected' : ''); ?>>Business</option>
                        <option value="LIS" <?php echo e($travellerType == 'LIS' ? 'selected' : ''); ?>>Leisure</option>
                      </select>
                      <?php $__errorArgs = ['traveller_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                      <label for="frequent_cities" class="form-label text-uppercase edit-profile-form-label">
                        Frequent cities you travel to
                      </label>
                      <select class="form-select" id="frequent_cities" name="frequent_cities[]" multiple data-placeholder="-Select-">
                        <option value="BLR" <?php echo e(in_array('BLR', $frequentCities) ? 'selected' : ''); ?>>Bengaluru</option>
                        <option value="KRL" <?php echo e(in_array('KRL', $frequentCities) ? 'selected' : ''); ?>>Bekal</option>
                        <option value="CH" <?php echo e(in_array('CH', $frequentCities) ? 'selected' : ''); ?>>Chandigarh</option>
                        <option value="GOA" <?php echo e(in_array('GOA', $frequentCities) ? 'selected' : ''); ?>>Goa</option>
                        <option value="KHJ" <?php echo e(in_array('KHJ', $frequentCities) ? 'selected' : ''); ?>>Khajuraho</option>
                        <option value="KL" <?php echo e(in_array('KL', $frequentCities) ? 'selected' : ''); ?>>Kolkata</option>
                        <option value="MN" <?php echo e(in_array('MN', $frequentCities) ? 'selected' : ''); ?>>Mangar</option>
                        <option value="MUM" <?php echo e(in_array('MUM', $frequentCities) ? 'selected' : ''); ?>>Mumbai</option>
                        <option value="DL" <?php echo e(in_array('DL', $frequentCities) ? 'selected' : ''); ?>>New Delhi</option>
                        <option value="SRI" <?php echo e(in_array('SRI', $frequentCities) ? 'selected' : ''); ?>>Sri Nagar</option>
                        <option value="UDI" <?php echo e(in_array('UDI', $frequentCities) ? 'selected' : ''); ?>>Udaypur</option>
                      </select>
                     
                      <?php $__errorArgs = ['frequent_cities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="room_preference" class="form-label text-uppercase edit-profile-form-label">
                        Room Preference
                      </label>
                      <select class="form-select" id="room_preference" name="room_preference[]" multiple data-placeholder="-Select-">
                        <option value="SM" <?php echo e(in_array('SM', $roomPreference) ? 'selected' : ''); ?>>Smoking</option>
                        <option value="NSK" <?php echo e(in_array('NSK', $roomPreference) ? 'selected' : ''); ?>>Non-Smoking</option>
                      </select>
                      <?php $__errorArgs = ['room_preference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                      <label for="beverage_preference" class="form-label text-uppercase edit-profile-form-label">
                        Beverage preference
                      </label>
                      <select class="form-select" id="beverage_preference" name="beverage_preference">
                        <option value="">Select</option>
                        <option value="ALC" <?php echo e($beveragePreference == 'ALC' ? 'selected' : ''); ?>>Alcoholic</option>
                        <option value="NALC" <?php echo e($beveragePreference == 'NALC' ? 'selected' : ''); ?>>Non Alcoholic</option>
                      </select>
                      <?php $__errorArgs = ['beverage_preference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="favourite_cuisine" class="form-label text-uppercase edit-profile-form-label">
                        Favourite cuisine
                      </label>
                      <select class="form-select" id="favourite_cuisine" name="favourite_cuisine[]" multiple data-placeholder="-Select-">
                        <option value="CONTINENTAL" <?php echo e(in_array('CONTINENTAL', $favouriteCuisine) ? 'selected' : ''); ?>>Continental Cuisine</option>
                        <option value="FRENCH" <?php echo e(in_array('FRENCH', $favouriteCuisine) ? 'selected' : ''); ?>>French Cuisine</option>
                        <option value="INDIAN" <?php echo e(in_array('INDIAN', $favouriteCuisine) ? 'selected' : ''); ?>>Indian Cuisine</option>
                        <option value="JAPANESE" <?php echo e(in_array('JAPANESE', $favouriteCuisine) ? 'selected' : ''); ?>>Japanese Cuisine</option>
                        <option value="MEXICAN" <?php echo e(in_array('MEXICAN', $favouriteCuisine) ? 'selected' : ''); ?>>Mexican Cuisine</option>
                        <option value="MULTI" <?php echo e(in_array('MULTI', $favouriteCuisine) ? 'selected' : ''); ?>>Multi Cuisine</option>
                      </select>
                      <?php $__errorArgs = ['favourite_cuisine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                      <label for="pillow_preference" class="form-label text-uppercase edit-profile-form-label">
                        Pillow Preference
                      </label>
                      <select class="form-select" id="pillow_preference" name="pillow_preference[]" multiple data-placeholder="-Select-">
                        <option value="FCP" <?php echo e(in_array('FCP', $pillowPreference) ? 'selected' : ''); ?>>Firm Cotton Pillow</option>
                        <option value="HHP" <?php echo e(in_array('HHP', $pillowPreference) ? 'selected' : ''); ?>>Harmony Hypoallergenic Pillow</option>
                        <option value="LSCP" <?php echo e(in_array('LSCP', $pillowPreference) ? 'selected' : ''); ?>>Lumbar support contourete Pillow</option>
                        <option value="NSP" <?php echo e(in_array('NSP', $pillowPreference) ? 'selected' : ''); ?>>Neck Support Pillow</option>
                      </select>
                      <?php $__errorArgs = ['pillow_preference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="room_should_be" class="form-label text-uppercase edit-profile-form-label">
                        Your room should be
                      </label>
                      <select class="form-select" id="room_should_be" name="room_should_be[]" multiple data-placeholder="-Select-">
                        <option value="HF" <?php echo e(in_array('HF', $roomShouldBe) ? 'selected' : ''); ?>>On High Floor</option>
                        <option value="LF" <?php echo e(in_array('LF', $roomShouldBe) ? 'selected' : ''); ?>>On Low Floor</option>
                        <option value="AE" <?php echo e(in_array('AE', $roomShouldBe) ? 'selected' : ''); ?>>Away from Elevator</option>
                        <option value="NE" <?php echo e(in_array('NE', $roomShouldBe) ? 'selected' : ''); ?>>Near Elevator</option>
                      </select>
                      <?php $__errorArgs = ['room_should_be'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                      <label for="dietary_preference" class="form-label text-uppercase edit-profile-form-label">
                        Any Dietary preference
                      </label>
                      <select class="form-select" id="dietary_preference" name="dietary_preference[]" multiple data-placeholder="-Select-">
                        <option value="EGG" <?php echo e(in_array('EGG', $dietaryPreference) ? 'selected' : ''); ?>>Eggeterian</option>
                        <option value="GLF" <?php echo e(in_array('GLF', $dietaryPreference) ? 'selected' : ''); ?>>Gluten-Free</option>
                        <option value="JAIN" <?php echo e(in_array('JAIN', $dietaryPreference) ? 'selected' : ''); ?>>Jain</option>
                        <option value="LCF" <?php echo e(in_array('LCF', $dietaryPreference) ? 'selected' : ''); ?>>Lactose Free</option>
                        <option value="NON-VEG" <?php echo e(in_array('NON-VEG', $dietaryPreference) ? 'selected' : ''); ?>>Non-Vegetarian</option>
                        <option value="SGF" <?php echo e(in_array('SGF', $dietaryPreference) ? 'selected' : ''); ?>>Sugar Free</option>
                        <option value="VEGAN" <?php echo e(in_array('VEGAN', $dietaryPreference) ? 'selected' : ''); ?>>Vegan</option>
                        <option value="VEG" <?php echo e(in_array('VEG', $dietaryPreference) ? 'selected' : ''); ?>>Vegetarian</option>
                      </select>
                      <?php $__errorArgs = ['dietary_preference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="row mb-4">
                    <div class="col-md-6">
                      <label for="allergies" class="form-label text-uppercase edit-profile-form-label">
                        Allergies
                      </label>
                     <select class="form-select" id="allergies" name="allergies[]" multiple data-placeholder="-Select-">
                        <option value="EGG" <?php echo e(in_array('EGG', $allergies) ? 'selected' : ''); ?>>Egg</option>
                        <option value="GLN" <?php echo e(in_array('GLN', $allergies) ? 'selected' : ''); ?>>Gluten</option>
                        <option value="LAC" <?php echo e(in_array('LAC', $allergies) ? 'selected' : ''); ?>>Lactose</option>
                        <option value="PNS" <?php echo e(in_array('PNS', $allergies) ? 'selected' : ''); ?>>Peanuts</option>
                        <option value="SEA" <?php echo e(in_array('SEA', $allergies) ? 'selected' : ''); ?>>Sea Food</option>
                        <option value="SOY" <?php echo e(in_array('SOY', $allergies) ? 'selected' : ''); ?>>Soy</option>
                      </select>
                      <?php $__errorArgs = ['allergies'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                      <label for="spice_level" class="form-label text-uppercase edit-profile-form-label">
                        Spice level in food
                      </label>
                      <select class="form-select" id="spice_level" name="spice_level">
                        <option value="">Select</option>
                        <option value="HIGH" <?php echo e($spiceLevel == 'HIGH' ? 'selected' : ''); ?>>High</option>
                        <option value="LOW" <?php echo e($spiceLevel == 'LOW' ? 'selected' : ''); ?>>Low</option>
                        <option value="MED" <?php echo e($spiceLevel == 'MED' ? 'selected' : ''); ?>>Medium</option>
                        <option value="NO" <?php echo e($spiceLevel == 'NO' ? 'selected' : ''); ?>>No Spice at all</option>
                      </select>
                      <?php $__errorArgs = ['spice_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="text-center">
                    <button type="submit" class="btn btn-dark px-5 py-2 text-uppercase edit-profile-save-btn">
                      SAVE CHANGES
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <!-- Change Password Tab -->
          <div class="tab-pane fade" id="password" role="tabpanel" aria-labelledby="password-tab">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h5 class="mb-4 edit-profile-section-title">Change Password</h5>
                <p class="text-muted mb-4">Update your password to keep your account secure.</p>

                <!-- Success/Error Alerts -->
                <div id="passwordChangeSuccess" class="alert alert-success alert-dismissible fade show d-none" role="alert">
                  <i class="fas fa-check-circle me-2"></i>
                  <span id="passwordChangeSuccessMessage"></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>

                <div id="passwordChangeError" class="alert alert-danger alert-dismissible fade show d-none" role="alert">
                  <i class="fas fa-exclamation-circle me-2"></i>
                  <span id="passwordChangeErrorMessage"></span>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>

                <form id="changePasswordForm" method="POST" action="<?php echo e(route('membership.update-password')); ?>">
                  <?php echo csrf_field(); ?>

                  <div class="row mb-4">
                    <div class="col-md-6 mx-auto">
                      <div class="mb-3">
                        <label for="current_password"
                          class="form-label text-uppercase edit-profile-password-label">CURRENT PASSWORD</label>
                        <div class="position-relative">
                          <input type="password" class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="current_password" name="current_password" required>
                          <button class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-decoration-none p-0 pe-3" 
                                  type="button" 
                                  onclick="togglePasswordVisibility('current_password')"
                                  style="border: none; background: none; z-index: 10; color: #6c757d;">
                            <i class="fas fa-eye" id="current_password_icon"></i>
                          </button>
                        </div>
                        <div class="invalid-feedback"></div>
                      </div>

                      <div class="mb-3">
                        <label for="new_password" class="form-label text-uppercase edit-profile-password-label">NEW
                          PASSWORD</label>
                        <div class="position-relative">
                          <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="new_password" name="password" required>
                          <button class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-decoration-none p-0 pe-3" 
                                  type="button" 
                                  onclick="togglePasswordVisibility('new_password')"
                                  style="border: none; background: none; z-index: 10; color: #6c757d;">
                            <i class="fas fa-eye" id="new_password_icon"></i>
                          </button>
                        </div>
                        <div class="invalid-feedback"></div>
                      </div>

                      <div class="mb-4">
                        <label for="password_confirmation"
                          class="form-label text-uppercase edit-profile-password-label">CONFIRM NEW PASSWORD</label>
                        <div class="position-relative">
                          <input type="password" class="form-control" id="password_confirmation"
                            name="password_confirmation" required>
                          <button class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-decoration-none p-0 pe-3" 
                                  type="button" 
                                  onclick="togglePasswordVisibility('password_confirmation')"
                                  style="border: none; background: none; z-index: 10; color: #6c757d;">
                            <i class="fas fa-eye" id="password_confirmation_icon"></i>
                          </button>
                        </div>
                        <div class="invalid-feedback"></div>
                      </div>
                    </div>
                  </div>

                  <div class="text-center">
                    <button type="submit" class="btn btn-dark px-5 py-2 text-uppercase edit-profile-password-btn">
                      UPDATE PASSWORD
                    </button>
                  </div>
                </form>

                <div class="alert alert-info mt-4">
                  <div class="d-flex">
                    <div class="flex-shrink-0">
                      <i class="fas fa-info-circle"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                      <h6 class="alert-heading">Password Requirements</h6>
                      <ul class="mb-0">
                        <li>At least 8 characters long</li>
                        <li>Include uppercase and lowercase letters</li>
                        <li>Include at least one number</li>
                        <li>Include at least one special character</li>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php $__env->startPush('scripts'); ?>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        // Auto-dismiss alerts after 5 seconds (only visible alerts, exclude password change alerts)
        const alerts = document.querySelectorAll('.alert-dismissible:not(#passwordChangeSuccess):not(#passwordChangeError)');
        alerts.forEach(function (alert) {
          if (!alert.classList.contains('d-none')) {
            setTimeout(function () {
              const bsAlert = new bootstrap.Alert(alert);
              bsAlert.close();
            }, 5000);
          }
        });

        // Form validation feedback (exclude password form as it has custom handling)
        const forms = document.querySelectorAll('form:not(#changePasswordForm)');
        forms.forEach(function (form) {
          form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
              event.preventDefault();
              event.stopPropagation();
            }
            form.classList.add('was-validated');
          });
        });

        // Tab navigation
        const tabButtons = document.querySelectorAll('[data-bs-toggle="tab"]');
        tabButtons.forEach(function (button) {
          button.addEventListener('shown.bs.tab', function (event) {
            // Optional: Add any custom behavior when tabs are switched
          });
        });

        // Address dropdown interactions
        const countrySelect = document.getElementById('country');
        const stateSelect = document.getElementById('state');
        const citySelect = document.getElementById('city');

        // Define route URLs
        const getRegionsUrl = '<?php echo e(url("/membership/get-regions")); ?>';
        const getCitiesUrl = '<?php echo e(url("/membership/get-cities")); ?>';

        // Handle country selection
        countrySelect.addEventListener('change', function () {
          const countryId = this.value;

          // Reset dependent dropdowns
          stateSelect.innerHTML = '<option value="">Select State/Region</option>';
          citySelect.innerHTML = '<option value="">Select City</option>';
          stateSelect.disabled = !countryId;
          citySelect.disabled = true;

          if (countryId) {
            // Show loading state
            stateSelect.innerHTML = '<option value="">Loading...</option>';

            // Fetch regions
            fetch(`${getRegionsUrl}/${countryId}`)
              .then(response => response.json())
              .then(data => {
                if (data.success) {
                  stateSelect.innerHTML = '<option value="">Select State/Region</option>';
                  data.data.forEach(region => {
                    const option = document.createElement('option');
                    option.value = region.region_id;
                    option.textContent = region.name;
                    option.dataset.regionCode = region.region_code;
                    option.dataset.regionId = region.region_id;
                    stateSelect.appendChild(option);
                  });
                  stateSelect.disabled = false;

                  // If editing existing member, try to select the current state
                  <?php if($member && $member->state): ?>
                    const currentState = '<?php echo e($member->state); ?>';
                    const stateOption = Array.from(stateSelect.options).find(option =>
                      option.textContent === currentState || option.value === currentState
                    );
                    if (stateOption) {
                      stateOption.selected = true;
                      stateSelect.dispatchEvent(new Event('change'));
                    }
                  <?php endif; ?>
                    } else {
                  stateSelect.innerHTML = '<option value="">Error loading regions</option>';
                }
              })
              .catch(error => {
                console.error('Error fetching regions:', error);
                stateSelect.innerHTML = '<option value="">Error loading regions</option>';
              });
          }
        });

        // Handle state/region selection
        stateSelect.addEventListener('change', function () {
          const selectedOption = this.options[this.selectedIndex];
          const regionId = selectedOption.dataset.regionId; // Use database ID for API call
          const regionIdValue = this.value; // This is region_id for form submission

          // Reset city dropdown
          citySelect.innerHTML = '<option value="">Select City</option>';
          citySelect.disabled = !regionId;

          if (regionId) {
            // Show loading state
            citySelect.innerHTML = '<option value="">Loading cities...</option>';

            // Fetch cities from API
            fetch(`${getCitiesUrl}/${regionId}`)
              .then(response => response.json())
              .then(data => {
                if (data.success) {
                  citySelect.innerHTML = '<option value="">Select City</option>';
                  data.data.forEach(city => {
                    const option = document.createElement('option');
                    option.value = city.id; // Store city name as value
                    option.textContent = city.name;
                    option.dataset.cityId = city.id;
                    option.dataset.cityCode = city.city_code;
                    citySelect.appendChild(option);
                  });
                  citySelect.disabled = false;

                  // If editing existing member, try to select the current city
                  <?php if($member && $member->city): ?>
                    const currentCity = '<?php echo e($member->city); ?>';
                    const cityOption = Array.from(citySelect.options).find(option =>
                      option.value === currentCity || option.dataset.cityId === currentCity
                    );
                    if (cityOption) {
                      cityOption.selected = true;
                    }
                  <?php endif; ?>
                    } else {
                  citySelect.innerHTML = '<option value="">Error loading cities</option>';
                }
              })
              .catch(error => {
                console.error('Error fetching cities:', error);
                citySelect.innerHTML = '<option value="">Error loading cities</option>';
              });
          }
        });

        // City selection handler - Update hidden inputs when city is selected
        citySelect.addEventListener('change', function () {
          const selectedOption = this.options[this.selectedIndex];
          const cityIdInput = document.getElementById('city_id');
          const cityNameInput = document.getElementById('city_name');
          
          if (selectedOption.value && selectedOption.dataset.cityId) {
            cityIdInput.value = selectedOption.dataset.cityId;
            cityNameInput.value = selectedOption.value;
          } else {
            cityIdInput.value = '';
            cityNameInput.value = '';
          }
        });

        // State/Region selection handler - Update hidden inputs when region is selected
        stateSelect.addEventListener('change', function () {
          const selectedOption = this.options[this.selectedIndex];
          const regionIdInput = document.getElementById('region_id');
          const regionNameInput = document.getElementById('region_name');
          
          if (selectedOption.value && selectedOption.dataset.regionId) {
            regionIdInput.value = selectedOption.dataset.regionId;
            regionNameInput.value = selectedOption.textContent;
          } else {
            regionIdInput.value = '';
            regionNameInput.value = '';
          }
        });

        // Postal code validation
        const postalCodeInput = document.getElementById('postal_code');
        postalCodeInput.addEventListener('input', function () {
          // Remove non-numeric characters
          this.value = this.value.replace(/\D/g, '');

          // Limit to 6 digits
          if (this.value.length > 6) {
            this.value = this.value.substring(0, 6);
          }
        });

        // Initialize dropdowns if editing existing member
        <?php if($member && $member->country): ?>
          // Trigger country change to load states
          const memberCountry = '<?php echo e($member->country); ?>';
          const countryOption = Array.from(countrySelect.options).find(option =>
            option.value === memberCountry || option.dataset.countryName === memberCountry
          );
          if (countryOption) {
            countryOption.selected = true;
            countrySelect.dispatchEvent(new Event('change'));
          }
        <?php endif; ?>

        // Handle Change Password Form Submission
        const changePasswordForm = document.getElementById('changePasswordForm');
        if (changePasswordForm) {
          changePasswordForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Clear previous messages
            const successAlert = document.getElementById('passwordChangeSuccess');
            const errorAlert = document.getElementById('passwordChangeError');
            const successMessage = document.getElementById('passwordChangeSuccessMessage');
            const errorMessage = document.getElementById('passwordChangeErrorMessage');
            
            successAlert.classList.add('d-none');
            errorAlert.classList.add('d-none');
            
            // Get form data
            const formData = new FormData(this);
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Updating...';
            
            try {
              const response = await fetch(this.action, {
                method: 'POST',
                body: formData,
                headers: {
                  'X-Requested-With': 'XMLHttpRequest',
                  'Accept': 'application/json'
                }
              });
              
              const data = await response.json();
              
              if (data.success) {
                // Show success message
                successMessage.textContent = data.message || 'Password changed successfully.';
                successAlert.classList.remove('d-none');
                
                // Reset form
                this.reset();
                this.classList.remove('was-validated');
                
                // Auto-dismiss after 5 seconds
                setTimeout(() => {
                  successAlert.classList.add('d-none');
                }, 5000);
              } else {
                // Show error message
                let errorText = data.message || 'Failed to change password. Please try again.';
                
                // Handle nested message object
                if (typeof data.message === 'object' && data.message.message) {
                  errorText = data.message.message;
                }
                
                // If there are validation errors, show them instead of generic message
                if (data.errors && Object.keys(data.errors).length > 0) {
                  // Collect all error messages
                  const errorMessages = [];
                  Object.keys(data.errors).forEach(key => {
                    if (Array.isArray(data.errors[key])) {
                      errorMessages.push(...data.errors[key]);
                    } else {
                      errorMessages.push(data.errors[key]);
                    }
                  });
                  
                  // Show the first error or all errors joined
                  if (errorMessages.length > 0) {
                    errorText = errorMessages.join(' ');
                  }
                }
                
                errorMessage.textContent = errorText;
                errorAlert.classList.remove('d-none');
                
                // Handle field-specific errors
                if (data.errors) {
                  Object.keys(data.errors).forEach(key => {
                    const input = this.querySelector(`[name="${key}"]`);
                    if (input) {
                      input.classList.add('is-invalid');
                      const feedback = input.nextElementSibling;
                      if (feedback && feedback.classList.contains('invalid-feedback')) {
                        feedback.textContent = data.errors[key][0];
                      }
                    }
                  });
                }
              }
            } catch (error) {
              console.error('Change Password Error:', error);
              errorMessage.textContent = 'An error occurred while changing password. Please try again.';
              errorAlert.classList.remove('d-none');
            } finally {
              // Restore button state
              submitBtn.disabled = false;
              submitBtn.innerHTML = originalBtnText;
            }
          });
          
          // Clear validation errors on input
          const passwordInputs = changePasswordForm.querySelectorAll('input[type="password"]');
          passwordInputs.forEach(input => {
            input.addEventListener('input', function() {
              this.classList.remove('is-invalid');
              const feedback = this.nextElementSibling;
              if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = '';
              }
            });
          });
        }

        // Handle Update Preferences Form Submission
        const updatePreferencesForm = document.getElementById('updatePreferencesForm');
        if (updatePreferencesForm) {
          updatePreferencesForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Clear previous messages
            const successAlert = document.getElementById('preferencesSuccess');
            const errorAlert = document.getElementById('preferencesError');
            const successMessage = document.getElementById('preferencesSuccessMessage');
            const errorMessage = document.getElementById('preferencesErrorMessage');
            
            successAlert.classList.add('d-none');
            errorAlert.classList.add('d-none');
            
            // Get form data
            const formData = new FormData(this);
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Updating...';
            
            try {
              const response = await fetch(this.action, {
                method: 'POST',
                body: formData,
                headers: {
                  'X-Requested-With': 'XMLHttpRequest',
                  'Accept': 'application/json'
                }
              });
              
              const data = await response.json();
              
              if (data.success) {
                // Show success message
                successMessage.textContent = data.message || 'Preferences updated successfully.';
                successAlert.classList.remove('d-none');
                
                // Scroll to top of tab content to show message
                document.getElementById('preferences').scrollIntoView({ behavior: 'smooth', block: 'start' });
                
                // Auto-dismiss after 5 seconds
                setTimeout(() => {
                  successAlert.classList.add('d-none');
                }, 5000);
              } else {
                // Show error message
                let errorText = data.message || 'Failed to update preferences. Please try again.';
                
                // Handle nested message object
                if (typeof data.message === 'object' && data.message.message) {
                  errorText = data.message.message;
                }
                
                // If there are validation errors, show them
                if (data.errors && Object.keys(data.errors).length > 0) {
                  const errorMessages = [];
                  Object.keys(data.errors).forEach(key => {
                    if (Array.isArray(data.errors[key])) {
                      errorMessages.push(...data.errors[key]);
                    } else {
                      errorMessages.push(data.errors[key]);
                    }
                  });
                  
                  if (errorMessages.length > 0) {
                    errorText = errorMessages.join(' ');
                  }
                }
                
                errorMessage.textContent = errorText;
                errorAlert.classList.remove('d-none');
                
                // Scroll to top to show error
                document.getElementById('preferences').scrollIntoView({ behavior: 'smooth', block: 'start' });
                
                // Handle field-specific errors
                if (data.errors) {
                  Object.keys(data.errors).forEach(key => {
                    const input = this.querySelector(`[name="${key}"]`);
                    if (input) {
                      input.classList.add('is-invalid');
                      const errorDiv = input.nextElementSibling;
                      if (errorDiv && errorDiv.classList.contains('text-danger')) {
                        errorDiv.textContent = data.errors[key][0];
                      }
                    }
                  });
                }
              }
            } catch (error) {
              console.error('Update Preferences Error:', error);
              errorMessage.textContent = 'An error occurred while updating preferences. Please try again.';
              errorAlert.classList.remove('d-none');
              document.getElementById('preferences').scrollIntoView({ behavior: 'smooth', block: 'start' });
            } finally {
              // Restore button state
              submitBtn.disabled = false;
              submitBtn.innerHTML = originalBtnText;
            }
          });
          
          // Clear validation errors on input
          const preferencesInputs = updatePreferencesForm.querySelectorAll('input, select');
          preferencesInputs.forEach(input => {
            input.addEventListener('input', function() {
              this.classList.remove('is-invalid');
              const errorDiv = this.nextElementSibling;
              if (errorDiv && errorDiv.classList.contains('text-danger')) {
                errorDiv.textContent = '';
              }
            });
          });
        }

        // Password visibility toggle function
        window.togglePasswordVisibility = function(fieldId) {
          const passwordField = document.getElementById(fieldId);
          const icon = document.getElementById(fieldId + '_icon');
          
          if (passwordField && icon) {
            if (passwordField.type === 'password') {
              passwordField.type = 'text';
              icon.classList.remove('fa-eye');
              icon.classList.add('fa-eye-slash');
            } else {
              passwordField.type = 'password';
              icon.classList.remove('fa-eye-slash');
              icon.classList.add('fa-eye');
            }
          }
        };
      });
    </script>

    <!-- jQuery (required for Select2) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 on all select elements in Preferences tab
        $('#preferences select').each(function() {
          const $select = $(this);
          const isMultiple = $select.prop('multiple');
          const placeholder = $select.data('placeholder') || $select.find('option:first').text() || 'Select...';
          
          $select.select2({
            theme: 'bootstrap-5',
            width: '100%',
            placeholder: placeholder,
            allowClear: !isMultiple,
            closeOnSelect: !isMultiple,
            tags: false
          });
        });

        // Handle form submission to ensure select2 values are included
        $('#updatePreferencesForm').on('submit', function() {
          // Trigger change event on all select2 elements to ensure values are captured
          $('#preferences select').each(function() {
            $(this).trigger('change.select2');
          });
        });

        // Clear validation errors when select2 changes
        $('#preferences select').on('change', function() {
          $(this).removeClass('is-invalid');
          const errorDiv = $(this).next('.text-danger');
          if (errorDiv.length) {
            errorDiv.text('');
          }
        });
      });
    </script>
  <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.membership', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/membership/edit-profile.blade.php ENDPATH**/ ?>