<?php $__env->startSection('title', 'My Rewards - The LaLiT Loyalty'); ?>

<?php $__env->startSection('content'); ?>
  <div class="container py-4">
    <!-- Header Section -->
    <div class="row mb-4 justify-content-center">
      <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <h2 class="fw-bold text-dark mb-0">My Rewards</h2>
          <a href="<?php echo e(route('membership.dashboard')); ?>" class="btn back-to-dashboard-btn">
            <i class="fas fa-arrow-left me-2"></i>BACK TO DASHBOARD
          </a>
        </div>
      </div>
    </div>

    <!-- Points Display -->
    <div class="row mb-4 justify-content-center">
      <div class="col-10">
        <div class="text-center py-5" style="background-color: #f8f9fa; border-radius: 8px;">
          <h3 class="text-dark mb-0">YOU HAVE <?php echo e(number_format($userPoints)); ?> LALIT LOYALTY POINTS</h3>
        </div>
      </div>
    </div>

    <!-- Filter Section -->
    <div class="row mb-4">
      <div class="col-12">
        <div class="d-flex justify-content-end align-items-center flex-wrap gap-3">
          <!-- Location/Hotel Filter -->
          <div class="filter-group">
            <select class="form-select" id="locationFilter" style="min-width: 200px;">
              <option value="">LOCATION / HOTEL</option>
              <option value="mumbai">Mumbai</option>
              <option value="delhi">Delhi</option>
              <option value="bengaluru">Bengaluru</option>
              <option value="goa">Goa</option>
              <option value="jaipur">Jaipur</option>
            </select>
          </div>

          <!-- Category Filter -->
          <div class="filter-group">
            <select class="form-select" id="categoryFilter" style="min-width: 180px;">
              <option value="">CATEGORY</option>
              <option value="dining">Dining</option>
              <option value="spa">Spa & Wellness</option>
              <option value="accommodation">Accommodation</option>
              <option value="experiences">Experiences</option>
              <option value="retail">Retail</option>
            </select>
          </div>

          <!-- Sort Filter -->
          <div class="filter-group">
            <select class="form-select" id="sortFilter" style="min-width: 200px;">
              <option value="expiring">SORT BY EXPIRING SOON</option>
              <option value="points-low">Points: Low to High</option>
              <option value="points-high">Points: High to Low</option>
              <option value="newest">Newest First</option>
              <option value="popular">Most Popular</option>
            </select>
          </div>
        </div>
      </div>
    </div>

    <!-- Rewards Grid -->
    <div class="row" id="rewardsGrid">
      <?php if(count($availableRewards) > 0): ?>
        <?php $__currentLoopData = $availableRewards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-lg-4 col-md-6 mb-4 reward-item" data-category="<?php echo e($reward['category']); ?>"
            data-location="<?php echo e($reward['location']); ?>" data-points="<?php echo e($reward['points_required']); ?>"
            data-expiry="<?php echo e($reward['expiry_date']); ?>" data-popular="<?php echo e($reward['popular'] ? 'true' : 'false'); ?>">
            <div class="card border-0 shadow-sm h-100 reward-card" data-reward-id="<?php echo e($reward['id']); ?>">
              <?php if($reward['image']): ?>
                <img src="<?php echo e(asset('storage/' . $reward['image'])); ?>" class="card-img-top" alt="<?php echo e($reward['title']); ?>"
                  style="height: 200px; object-fit: cover;">
              <?php else: ?>
                <div class="card-img-top d-flex align-items-center justify-content-center" style="height: 200px;">
                  <i class="fas fa-gift fa-3x text-muted"></i>
                </div>
              <?php endif; ?>

              <div class="card-body d-flex flex-column">
                <h5 class="card-title"><?php echo e($reward['title']); ?></h5>
                <p class="card-text text-muted flex-grow-1"><?php echo e($reward['description']); ?></p>

                <div class="d-flex justify-content-between align-items-center mb-3">
                  <div class="points-required">
                    <span class="badge bg-warning text-dark">
                      <i class="fas fa-coins me-1"></i><?php echo e(number_format($reward['points_required'])); ?> Points
                    </span>
                  </div>
                  <?php if($reward['expiry_date']): ?>
                    <small class="text-muted">
                      <i class="fas fa-clock me-1"></i>Expires: <?php echo e(\Carbon\Carbon::parse($reward['expiry_date'])->format('M j,
                      Y')); ?>

                    </small>
                  <?php endif; ?>
                </div>

                <div class="d-flex justify-content-between align-items-center mb-3">
                  <small class="text-muted text-capitalize">
                    <i class="fas fa-map-marker-alt me-1"></i><?php echo e(ucfirst($reward['location'])); ?>

                  </small>
                  <small class="text-muted text-capitalize">
                    <i class="fas fa-tag me-1"></i><?php echo e(ucfirst($reward['category'])); ?>

                  </small>
                </div>

                <div class="d-grid">
                  <?php if($userPoints >= $reward['points_required']): ?>
                    <button class="btn btn-dark px-5 py-2 text-uppercase edit-profile-save-btn redeem-btn"
                      data-reward-id="<?php echo e($reward['id']); ?>" data-points="<?php echo e($reward['points_required']); ?>">
                      <i class="fas fa-check me-2"></i>Redeem Now
                    </button>
                  <?php else: ?>
                    <button class="btn btn-outline-secondary" disabled>
                      <i class="fas fa-lock me-2"></i>Insufficient Points
                    </button>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php else: ?>
        <div class="col-12">
          <div class="text-center py-5">
            <i class="fas fa-gift fa-4x text-muted mb-4"></i>
            <h4 class="text-muted">No Rewards Available</h4>
            <p class="text-muted">Check back soon for exciting new rewards!</p>
          </div>
        </div>
      <?php endif; ?>
    </div>

    <!-- No Results Message (Hidden by default) -->
    <div class="row" id="noResults" style="display: none;">
      <div class="col-12">
        <div class="text-center py-5">
          <i class="fas fa-search fa-4x text-muted mb-4"></i>
          <h4 class="text-muted">No Rewards Found</h4>
          <p class="text-muted">Try adjusting your filters to find more rewards.</p>
          <button class="btn btn-primary" id="clearFilters">
            <i class="fas fa-times me-2"></i>Clear All Filters
          </button>
        </div>
      </div>
    </div>

    <!-- Summary Section -->
    <div class="row mt-5">
      <div class="col-12">
        <div class="card border-0 shadow-sm" style="background-color: #f5f0eb;">
          <div class="card-body">
            <div class="row text-center">
              <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="h4 text-primary mb-1"><?php echo e(number_format($userPoints)); ?></div>
                <div class="text-muted small">Available Points</div>
              </div>
              <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="h4 text-success mb-1"><?php echo e(count($earnedRewards)); ?></div>
                <div class="text-muted small">Earned Rewards</div>
              </div>
              <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="h4 text-warning mb-1"><?php echo e($availableRewards->count()); ?></div>
                <div class="text-muted small">Available Rewards</div>
              </div>
              <div class="col-md-3 col-6 mb-3 mb-md-0">
                <div class="h4 text-info mb-1"><?php echo e($availableRewards->where('popular', true)->count()); ?></div>
                <div class="text-muted small">Popular Rewards</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Redeem Confirmation Modal -->
  <div class="modal fade" id="redeemModal" tabindex="-1" aria-labelledby="redeemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="redeemModalLabel">Confirm Reward Redemption</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="text-center">
            <i class="fas fa-gift fa-3x text-primary mb-3"></i>
            <h6 id="reward-title">Reward Title</h6>
            <p class="text-muted mb-3">You are about to redeem this reward for <span id="points-required"
                class="fw-bold text-primary"></span> points.</p>
            <div class="alert alert-warning">
              <small><i class="fas fa-exclamation-triangle me-2"></i>This action cannot be undone.</small>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="button" class="btn btn-primary" id="confirm-redeem">
            <i class="fas fa-check me-2"></i>Confirm Redemption
          </button>
        </div>
      </div>
    </div>
  </div>

  <?php $__env->startPush('scripts'); ?>
    <script>
      document.addEventListener('DOMContentLoaded', function () {
        let currentRewardId = null;
        let currentPoints = null;

        const rewardItems = document.querySelectorAll('.reward-item');
        const locationFilter = document.getElementById('locationFilter');
        const categoryFilter = document.getElementById('categoryFilter');
        const sortFilter = document.getElementById('sortFilter');
        const rewardsGrid = document.getElementById('rewardsGrid');
        const noResults = document.getElementById('noResults');
        const clearFiltersBtn = document.getElementById('clearFilters');

        // Filter functionality
        function filterRewards() {
          const locationValue = locationFilter.value;
          const categoryValue = categoryFilter.value;
          const sortValue = sortFilter.value;

          let visibleRewards = [];

          rewardItems.forEach(function (item) {
            let showItem = true;

            // Filter by location
            if (locationValue && item.dataset.location !== locationValue) {
              showItem = false;
            }

            // Filter by category
            if (categoryValue && item.dataset.category !== categoryValue) {
              showItem = false;
            }

            if (showItem) {
              item.style.display = 'block';
              visibleRewards.push(item);
            } else {
              item.style.display = 'none';
            }
          });

          // Sort visible rewards
          if (visibleRewards.length > 0) {
            visibleRewards.sort(function (a, b) {
              switch (sortValue) {
                case 'points-low':
                  return parseInt(a.dataset.points) - parseInt(b.dataset.points);
                case 'points-high':
                  return parseInt(b.dataset.points) - parseInt(a.dataset.points);
                case 'popular':
                  return (b.dataset.popular === 'true') - (a.dataset.popular === 'true');
                case 'expiring':
                default:
                  return new Date(a.dataset.expiry) - new Date(b.dataset.expiry);
              }
            });

            // Reorder DOM elements
            visibleRewards.forEach(function (item) {
              rewardsGrid.appendChild(item);
            });
          }

          // Show/hide no results message
          if (visibleRewards.length === 0) {
            rewardsGrid.style.display = 'none';
            noResults.style.display = 'block';
          } else {
            rewardsGrid.style.display = 'flex';
            noResults.style.display = 'none';
          }
        }

        // Add event listeners
        locationFilter.addEventListener('change', filterRewards);
        categoryFilter.addEventListener('change', filterRewards);
        sortFilter.addEventListener('change', filterRewards);

        // Clear filters
        clearFiltersBtn.addEventListener('click', function () {
          locationFilter.value = '';
          categoryFilter.value = '';
          sortFilter.value = 'expiring';
          filterRewards();
        });

        // Handle redeem button clicks
        document.querySelectorAll('.redeem-btn').forEach(function (button) {
          button.addEventListener('click', function () {
            currentRewardId = this.getAttribute('data-reward-id');
            currentPoints = this.getAttribute('data-points');

            const rewardCard = this.closest('.reward-card');
            const rewardTitle = rewardCard.querySelector('.card-title').textContent;

            document.getElementById('reward-title').textContent = rewardTitle;
            document.getElementById('points-required').textContent = parseInt(currentPoints).toLocaleString();

            const modal = new bootstrap.Modal(document.getElementById('redeemModal'));
            modal.show();
          });
        });

        // Handle confirmation
        document.getElementById('confirm-redeem').addEventListener('click', function () {
          if (currentRewardId && currentPoints) {
            redeemReward(currentRewardId, currentPoints);
          }
        });

        function redeemReward(rewardId, points) {
          const button = document.querySelector(`[data-reward-id="${rewardId}"]`);
          const originalText = button.innerHTML;

          // Show loading state
          button.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
          button.disabled = true;

          // Simulate API call (replace with actual API call when ready)
          setTimeout(function () {
            // Show success message
            showAlert('success', 'Reward redeemed successfully!');

            // Update button
            button.innerHTML = '<i class="fas fa-check me-2"></i>Redeemed!';
            button.classList.remove('btn-dark');
            button.classList.add('btn-success');

            // Update points display
            const currentPoints = parseInt('<?php echo e($userPoints); ?>') - parseInt(points);
            document.querySelector('h3').innerHTML = `YOU HAVE ${currentPoints.toLocaleString()} LALIT LOYALTY POINTS`;

            // Hide modal
            bootstrap.Modal.getInstance(document.getElementById('redeemModal')).hide();
          }, 2000);
        }

        function showAlert(type, message) {
          const alertHTML = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `;

          const container = document.querySelector('.container-fluid');
          container.insertAdjacentHTML('afterbegin', alertHTML);

          // Auto-dismiss after 5 seconds
          setTimeout(() => {
            const alert = document.querySelector('.alert:first-of-type');
            if (alert) {
              const bsAlert = new bootstrap.Alert(alert);
              bsAlert.close();
            }
          }, 5000);
        }

        // Initial filter application
        filterRewards();
      });
    </script>
  <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.membership', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/membership/myrewards.blade.php ENDPATH**/ ?>