<?php $__env->startSection('title', $page->seo_title); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Custom styles for this page */
    .page-header {
        margin-top: 3rem;
    }

    /* Desktop-only top margin */
    @media (min-width: 992px) {
        .page-header {
            margin-top: 7rem;
        }
    }
</style>

<!-- SEO Meta Tags -->
<meta name="description" content="<?php echo e($page->seo_description); ?>">
<?php if($page->meta_keywords): ?>
<meta name="keywords" content="<?php echo e($page->meta_keywords); ?>">
<?php endif; ?>
<meta name="robots" content="<?php echo e($page->meta_robots ?? 'index,follow'); ?>">

<?php if($page->canonical_url): ?>
<link rel="canonical" href="<?php echo e($page->canonical_url); ?>">
<?php endif; ?>

<!-- Open Graph Meta Tags -->
<?php if($page->og_data): ?>
<meta property="og:title" content="<?php echo e($page->og_data['title'] ?? $page->title); ?>">
<meta property="og:description" content="<?php echo e($page->og_data['description'] ?? $page->seo_description); ?>">
<meta property="og:type" content="<?php echo e($page->og_data['type'] ?? 'article'); ?>">
<meta property="og:url" content="<?php echo e($page->url); ?>">
<?php if(isset($page->og_data['image'])): ?>
<meta property="og:image" content="<?php echo e($page->og_data['image']); ?>">
<?php elseif($page->featured_image): ?>
<meta property="og:image" content="<?php echo e($page->featured_image); ?>">
<?php endif; ?>
<?php endif; ?>

<!-- Twitter Card Meta Tags -->
<?php if($page->twitter_data): ?>
<meta name="twitter:card" content="<?php echo e($page->twitter_data['card'] ?? 'summary'); ?>">
<meta name="twitter:title" content="<?php echo e($page->twitter_data['title'] ?? $page->title); ?>">
<meta name="twitter:description" content="<?php echo e($page->twitter_data['description'] ?? $page->seo_description); ?>">
<?php if(isset($page->twitter_data['image'])): ?>
<meta name="twitter:image" content="<?php echo e($page->twitter_data['image']); ?>">
<?php elseif($page->featured_image): ?>
<meta name="twitter:image" content="<?php echo e($page->featured_image); ?>">
<?php endif; ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Structured Data -->
<?php if($page->schema_markup): ?>
<script type="application/ld+json">
    <?php echo $page->schema_markup; ?>

</script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('hero'); ?>
<!-- Banner Image as Hero Section -->
<?php if($page->banner_image): ?>
<div class="hero-banner position-relative">
    <div class="hero-image">
        <img src="<?php echo e($page->banner_image); ?>" 
             alt="<?php echo e($page->banner_image_alt ?? 'Banner image'); ?>" 
             class="w-100" style="height: 25rem; object-fit: cover;">
    </div>
    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100" style="background: linear-gradient(135deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0.2) 50%, rgba(0,0,0,0.4) 100%);"></div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Content Section -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">                
                <!-- Page Header -->
                <header class="page-header mb-5">
                    <h1 class="section-title mb-4 text-uppercase"><?php echo e($page->title); ?></h1>
                    <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                    <?php if($page->excerpt): ?>
                    <p class="section-subtitle mb-4"><?php echo e($page->excerpt); ?></p>
                    <?php endif; ?>
                </header>

                <!-- Featured Image -->
                <?php if($page->featured_image): ?>
                <div class="mb-5">
                    <figure class="text-center">
                        <img src="<?php echo e($page->featured_image); ?>" 
                             alt="<?php echo e($page->featured_image_alt ?? $page->title); ?>" 
                             class="img-fluid rounded shadow">
                        <?php if($page->featured_image_caption): ?>
                        <figcaption class="mt-3 text-muted fst-italic">
                            <?php echo e($page->featured_image_caption); ?>

                        </figcaption>
                        <?php endif; ?>
                    </figure>
                </div>
                <?php endif; ?>

                <!-- Page Content -->
                <article class="page-content">
                    <div class="content-wrapper" style="font-size: 1.1rem; line-height: 1.6; color: #212322;">
                        <?php if($page->content): ?>
                        <?php echo $page->content; ?>


                        <?php else: ?>
                        <!-- Contact Information Section -->
                        <div class="mt-5 pt-5 border-top border-2 border-light">
                            <div class="row g-4">
                                <!-- Common Queries Contact Information -->
                                <div class="col-lg-6">
                                    <div class="h-100 p-4 bg-light rounded shadow-sm border">
                                        <div class="mb-4">
                                            <h3 class="h4 fw-bold mb-3 text-black">
                                                <i class="fas fa-headset me-2"></i>Common Queries & Support
                                            </h3>
                                            <hr class="border-3 border-black w-25 mt-0">
                                        </div>

                                        <div>
                                            <div class="py-3 border-bottom">
                                                <h5 class="mb-2">
                                                    <i class="fas fa-envelope text-black me-2"></i>Email Support
                                                </h5>
                                                <p class="mb-2 fs-6">
                                                    <a href="mailto:loyaltyhelpdesk@thelalit.com" class="text-decoration-none text-dark fw-semibold">
                                                        loyaltyhelpdesk@thelalit.com
                                                    </a>
                                                    <br>
                                                    <a href="mailto:reachus@thelalitloyalty.com" class="text-decoration-none text-dark fw-semibold">
                                                        reachus@thelalitloyalty.com
                                                    </a>
                                                </p>
                                            </div>

                                            <div class="py-3 border-bottom">
                                                <h5 class="mb-2">
                                                    <i class="fas fa-phone text-black me-2"></i>General Support
                                                </h5>
                                                <p class="mb-2 fs-6">
                                                    <a href="tel:18002024911" class="text-decoration-none text-dark fw-semibold">
                                                        18002024911
                                                    </a>
                                                </p>
                                                <small class="text-muted">(Monday - Saturday between 9 A.M. to 6 P.M.)</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Dedicated Member Service for Gold & Platinum Members -->
                                <div class="col-lg-6">
                                    <div class="h-100 p-4 rounded shadow-sm text-white" style="background-color: #f5f0eb;">
                                        <div class="mb-4">
                                            <h3 class="h4 fw-bold mb-3 text-black">
                                                <i class="fas fa-crown me-2"></i>Dedicated Member Service <small>(Gold and Platinum Members)</small>
                                            </h3>
                                            <hr class="border-3 border-black w-25 mt-0">
                                        </div>

                                        <div>
                                            <div class="mb-4 p-3 rounded text-black bg-opacity-10">
                                                <div>
                                                    <div class="py-3 border-bottom">
                                                        <h5 class="mb-2">
                                                            <i class="fas fa-envelope text-black me-2"></i>Email Support
                                                        </h5>
                                                        <p class="mb-2 fs-6">
                                                            <a href="mailto:priority@thelalitloyalty.comm" class="text-decoration-none text-dark fw-semibold">
                                                                priority@thelalitloyalty.com
                                                            </a>

                                                        </p>
                                                    </div>
                                                    <div class="py-3 border-bottom">
                                                        <h5 class="mb-2">
                                                            <i class="fas fa-phone text-black me-2"></i>Contact Support
                                                        </h5>
                                                        <p class="mb-2 fs-6">
                                                            <a href="tel:011-44447621" class="text-decoration-none text-dark fw-semibold">
                                                                011-44447621
                                                            </a>
                                                        </p>
                                                        <small class="text-muted">(Monday - Saturday between 9 A.M. to 6 P.M.)</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </article>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/contact.blade.php ENDPATH**/ ?>