

<?php $__env->startSection('title', 'Participating Hotels - The LaLiT Loyalty'); ?>

<?php $__env->startSection('content'); ?>
<div class="container px-4 py-5">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-bold mb-0" style="color: #212322; font-size: 2rem;">Participating Hotels</h2>
            <p class="text-muted mt-2">Experience luxury and comfort at our exclusive collection of hotels</p>
        </div>
    </div>

    <?php if($hotels->count() > 0): ?>
        <!-- Hotels List -->
        <div class="row g-4">
            <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12">
                    <div class="card hotel-card border-0 shadow-sm">
                        <div class="row g-0 align-items-center">
                            <!-- Hotel Image -->
                            <div class="col-md-3">
                                <div class="hotel-image-container">
                                    <?php if($hotel->image): ?>
                                        <img src="<?php echo e(Storage::url($hotel->image)); ?>" 
                                             class="img-fluid hotel-image" 
                                             alt="<?php echo e($hotel->title); ?>">
                                    <?php else: ?>
                                        <div class="hotel-image placeholder-image d-flex align-items-center justify-content-center">
                                            <i class="fas fa-building fa-3x text-muted"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Hotel Content -->
                            <div class="col-md-9">
                                <div class="card-body p-4">
                                    <h3 class="card-title fw-bold mb-3" style="color: #212322; font-size: 1.5rem;">
                                        <?php echo e($hotel->title); ?>

                                    </h3>
                                    
                                    <?php if($hotel->description): ?>
                                        <p class="card-text text-muted mb-0" style="line-height: 1.6; font-size: 0.95rem;">
                                            <?php echo e($hotel->description); ?>

                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <!-- No Hotels Message -->
        <div class="row">
            <div class="col-12">
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-building fa-4x text-muted"></i>
                    </div>
                    <h4 class="fw-bold text-muted mb-3">No Participating Hotels Available</h4>
                    <p class="text-muted">
                        We're working on adding more participating hotels to our network. 
                        Please check back later for updates.
                    </p>
                    <a href="https://www.thelalit.com/" target="_blank" class="btn btn-primary mt-3">
                        <i class="fas fa-globe me-2"></i>Visit Our Main Website
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
.hotel-card {
    transition: all 0.3s ease;
    border-radius: 15px;
    overflow: hidden;
}

.hotel-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.1) !important;
}

.hotel-image-container {
    height: 100%;
    min-height: 250px;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
}

.hotel-image {
    width: 80px;
    height: 80px;
    object-fit: contain;
    transition: transform 0.3s ease;
}

.hotel-card:hover .hotel-image {
    transform: scale(1.05);
}

.placeholder-image {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    height: 100%;
    min-height: 120px;
}

.feature-item {
    font-size: 0.9rem;
}

.feature-item i {
    width: 20px;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
}

.btn-outline-secondary {
    border: 2px solid #6c757d;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-outline-secondary:hover {
    transform: translateY(-2px);
    background-color: #6c757d;
    border-color: #6c757d;
}

.badge {
    font-size: 0.8rem;
    font-weight: 600;
}

@media (max-width: 768px) {
    .hotel-image-container {
        min-height: 200px;
    }
    
    .card-body {
        padding: 1.5rem !important;
    }
    
    .d-flex.gap-3 {
        flex-direction: column;
        gap: 0.5rem !important;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
    
    .feature-item {
        margin-bottom: 0.5rem;
    }
}

@media (max-width: 576px) {
    .row.g-0 {
        flex-direction: column;
    }
    
    .hotel-image-container {
        min-height: 180px;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.membership', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/membership/participating_hotels.blade.php ENDPATH**/ ?>