<?php

namespace App\Http\Controllers;

use App\Models\Charity;
use Illuminate\Http\Request;

class CharityController extends Controller
{
    /**
     * Display a listing of charities.
     */
    public function index()
    {
        $charities = Charity::active()
                           ->orderBy('sort_order')
                           ->orderBy('name')
                           ->get();
        
        return view('charity', compact('charities'));
    }

    /**
     * Display the specified charity.
     */
    public function show(Charity $charity)
    {
        // Only show active charities
        if ($charity->status !== 'active') {
            abort(404);
        }

        return view('charity-detail', compact('charity'));
    }
}
