<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use HasFactory;

    protected $fillable = [
        'region_id',
        'name',
        'city_code'
    ];

    /**
     * Get the region that owns the city.
     */
    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    /**
     * Get the country through region.
     */
    public function country()
    {
        return $this->hasOneThrough(Country::class, Region::class, 'id', 'country_id', 'region_id', 'country_id');
    }

    /**
     * Get the postcodes for the city.
     */
    public function postcodes()
    {
        return $this->hasMany(Postcode::class);
    }
}
