<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    protected $fillable = [
        'country_id',
        'name',
        'iso_code'
    ];

    /**
     * Get the regions for the country.
     */
    public function regions()
    {
        return $this->hasMany(Region::class, 'country_id', 'country_id');
    }

    /**
     * Get all cities through regions.
     */
    public function cities()
    {
        return $this->hasManyThrough(City::class, Region::class, 'country_id', 'region_id', 'country_id', 'id');
    }
}
