<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Postcode extends Model
{
    use HasFactory;

    protected $fillable = [
        'city_id',
        'pin_code'
    ];

    /**
     * Get the city that owns the postcode.
     */
    public function city()
    {
        return $this->belongsTo(City::class);
    }

    /**
     * Get the region through city.
     */
    public function region()
    {
        return $this->hasOneThrough(Region::class, City::class, 'id', 'id', 'city_id', 'region_id');
    }

    /**
     * Get the country through city and region.
     */
    public function country()
    {
        return $this->hasOneThrough(Country::class, City::class, 'id', 'country_id', 'city_id', 'region_id')
                    ->join('regions', 'regions.id', '=', 'cities.region_id');
    }
}
