<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Membership API Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for the third-party membership API integration
    |
    */

    'base_url' => env('MEMBERSHIP_API_URL', 'https://api.apm20.gravty.io'),
    
    'timeout' => env('MEMBERSHIP_API_TIMEOUT', 30),
    
    'username' => env('MEMBERSHIP_API_USERNAME'),
    
    'password' => env('MEMBERSHIP_API_PASSWORD'),
    
    'scope' => env('MEMBERSHIP_API_SCOPE', 'read write'),
    
    'key' => env('MEMBERSHIP_API_KEY'),
    
    'retry_attempts' => env('MEMBERSHIP_API_RETRY_ATTEMPTS', 3),
    
    'cache_ttl' => env('MEMBERSHIP_API_CACHE_TTL', 300),
    
    /*
    |--------------------------------------------------------------------------
    | Token Management
    |--------------------------------------------------------------------------
    |
    | Settings for API token management and cleanup
    |
    */
    
    'token' => [
        'cleanup_after_days' => 7, // Clean up expired tokens after this many days
        'refresh_threshold_minutes' => 5, // Refresh token if expiring within this time
    ],

];