<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('members', function (Blueprint $table) {
      $table->id();

      // API Response IDs
      $table->string('api_member_id')->unique()->nullable(); // Member ID from API
      $table->string('member_number')->unique()->nullable(); // Membership number
      $table->string('member_code')->nullable(); // Member code if provided

      // Personal Information
      $table->string('first_name');
      $table->string('last_name');
      $table->string('email')->unique();
      $table->string('mobile', 20);
      $table->date('date_of_birth')->nullable();
      $table->enum('gender', ['male', 'female', 'other'])->nullable();

      // Address Information
      $table->text('address_line1')->nullable();
      $table->text('address_line2')->nullable();
      $table->string('city')->nullable();
      $table->string('state')->nullable();
      $table->string('country')->nullable();
      $table->string('postal_code', 20)->nullable();

      // Membership Details
      $table->string('tier')->nullable(); // Membership tier
      $table->integer('points')->default(0); // Loyalty points
      $table->date('enrollment_date')->nullable();
      $table->integer('enrollment_touchpoint')->nullable();
      $table->string('enrollment_channel')->nullable();
      $table->integer('enrolling_sponsor')->nullable();
      $table->integer('enrolling_location')->nullable();

      // Status and Preferences
      $table->enum('status', ['active', 'inactive', 'suspended', 'pending'])->default('active');
      $table->boolean('email_verified')->default(false);
      $table->boolean('mobile_verified')->default(false);
      $table->boolean('marketing_opt_in')->default(false);

      // API Sync
      $table->json('extra_data')->nullable(); // Store any additional API data
      $table->timestamp('last_synced_at')->nullable();

      // Link to users table
      $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');

      $table->timestamps();
      $table->softDeletes(); // Soft delete support

      // Indexes for performance
      $table->index('email');
      $table->index('mobile');
      $table->index('member_number');
      $table->index('status');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('members');
  }
};
