<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('members', function (Blueprint $table) {
      $table->text('member_token')->nullable()->after('user_id');
      $table->timestamp('token_expires_at')->nullable()->after('member_token');
      $table->json('tier_data')->nullable()->after('tier');
      $table->json('balances')->nullable()->after('points');
      $table->timestamp('last_login_at')->nullable()->after('last_synced_at');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('members', function (Blueprint $table) {
      $table->dropColumn(['member_token', 'token_expires_at', 'tier_data', 'balances', 'last_login_at']);
    });
  }
};
