<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('donations', function (Blueprint $table) {
      $table->id();
      $table->string('title');
      $table->string('image')->nullable();
      $table->text('description')->nullable();
      $table->integer('donate_points'); // Points required to donate
      $table->decimal('donate_points_inr_value', 10, 2); // INR value equivalent of donation points
      $table->string('donation_link')->nullable(); // Link for donation processing
      $table->boolean('is_active')->default(true);
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('donations');
  }
};
