<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('regions', function (Blueprint $table) {
            $table->id();
            $table->integer('region_id')->nullable();
            $table->string('country_id');
            $table->string('name');
            $table->string('region_code')->nullable();
            $table->timestamps();
            
            $table->foreign('country_id')->references('country_id')->on('countries')->onDelete('cascade');
            $table->index('country_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('regions');
    }
};
