<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('members', function (Blueprint $table) {
            $table->string('title', 10)->nullable()->after('id');
            $table->string('middle_name')->nullable()->after('first_name');
            $table->string('nationality', 100)->nullable()->after('gender');
            $table->json('tier_data')->nullable()->after('tier');
            $table->json('balances')->nullable()->after('points');
            $table->timestamp('last_login_at')->nullable()->after('last_synced_at');
            $table->string('member_token')->nullable()->after('last_login_at');
            $table->timestamp('token_expires_at')->nullable()->after('member_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            $table->dropColumn([
                'title',
                'middle_name', 
                'nationality',
                'tier_data',
                'balances',
                'last_login_at',
                'member_token',
                'token_expires_at'
            ]);
        });
    }
};
