/**
 * Hero Slider Image Handler Script
 * Helps properly adjust carousel images based on screen size
 */
document.addEventListener('DOMContentLoaded', function() {
    // Function to adjust image heights
    function adjustSliderImageHeight() {
        const screenWidth = window.innerWidth;
        const heroSlider = document.getElementById('heroSlider');
        
        if (heroSlider) {
            // Hide the carousel indicators (pagination dots)
            const indicators = heroSlider.querySelector('.carousel-indicators');
            if (indicators) {
                indicators.style.display = 'none';
            }
            
            // Responsive height adjustment based on screen size
            let bannerHeight;
            
            if (screenWidth <= 576) {
                bannerHeight = '22vh'; // Small mobile
            } else if (screenWidth <= 768) {
                bannerHeight = '50vh'; // Mobile
            } else if (screenWidth <= 992) {
                bannerHeight = '60vh'; // Tablets
            } else {
                bannerHeight = '70vh'; // Desktop
            }
            
            const banners = heroSlider.querySelectorAll('.hero-banner');
            banners.forEach(banner => {
                banner.style.height = bannerHeight;
            });
            
            // Adjust caption visibility for mobile
            const captions = heroSlider.querySelectorAll('.carousel-caption');
            captions.forEach(caption => {
                if (screenWidth <= 576) {
                    caption.style.bottom = '10%';
                    caption.style.padding = '5px 10px';
                } else if (screenWidth <= 768) {
                    caption.style.bottom = '15%';
                    caption.style.padding = '10px 15px';
                } else {
                    caption.style.bottom = '20%';
                    caption.style.padding = '';
                }
            });
        }
    }

    // Run on page load
    adjustSliderImageHeight();
    
    // Run when window is resized
    window.addEventListener('resize', adjustSliderImageHeight);
    
    // Run when carousel slides
    const heroSlider = document.getElementById('heroSlider');
    if (heroSlider) {
        heroSlider.addEventListener('slid.bs.carousel', adjustSliderImageHeight);
    }
});
