@extends('layouts.admin')

@section('title', 'Edit Donation')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">Edit Donation</h5>
                            <p class="text-sm mb-0">
                                Update donation campaign details.
                            </p>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                                <a href="{{ route('admin.donations.index') }}" class="btn btn-outline-primary btn-sm mb-0 me-2">
                                    <i class="fas fa-arrow-left me-1"></i> Back to List
                                </a>
                                <a href="{{ route('admin.donations.show', $donation) }}" class="btn btn-outline-info btn-sm mb-0">
                                    <i class="fas fa-eye me-1"></i> View
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.donations.update', $donation) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">Basic Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 mb-3">
                                                <label class="form-label">Title <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       class="form-control @error('title') is-invalid @enderror" 
                                                       name="title" 
                                                       value="{{ old('title', $donation->title) }}" 
                                                       placeholder="Enter donation campaign title">
                                                @error('title')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-3">
                                                <label class="form-label">Description</label>
                                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                                          name="description" 
                                                          rows="4" 
                                                          placeholder="Describe the donation campaign">{{ old('description', $donation->description) }}</textarea>
                                                @error('description')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Donate Points <span class="text-danger">*</span></label>
                                                <input type="number" 
                                                       class="form-control @error('donate_points') is-invalid @enderror" 
                                                       name="donate_points" 
                                                       value="{{ old('donate_points', $donation->donate_points) }}" 
                                                       min="1" 
                                                       placeholder="Enter donation points">
                                                @error('donate_points')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">INR Value <span class="text-danger">*</span></label>
                                                <input type="number" 
                                                       class="form-control @error('donate_points_inr_value') is-invalid @enderror" 
                                                       name="donate_points_inr_value" 
                                                       value="{{ old('donate_points_inr_value', $donation->donate_points_inr_value) }}" 
                                                       min="0.01" 
                                                       step="0.01" 
                                                       placeholder="Enter INR value">
                                                @error('donate_points_inr_value')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Additional Details -->
                                {{-- <div class="card mt-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Additional Details</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 mb-3">
                                                <label class="form-label">Donation Link</label>
                                                <input type="url" 
                                                       class="form-control @error('donation_link') is-invalid @enderror" 
                                                       name="donation_link" 
                                                       value="{{ old('donation_link', $donation->donation_link) }}" 
                                                       placeholder="Enter donation processing link">
                                                <small class="text-muted">URL where users will be redirected for donation processing</small>
                                                @error('donation_link')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}
                            </div>

                            <!-- Settings & Media -->
                            <div class="col-md-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">Current Image</h6>
                                    </div>
                                    <div class="card-body text-center">
                                        @if($donation->image)
                                            <img src="{{ Storage::url($donation->image) }}" 
                                                 alt="Current Donation Image" 
                                                 class="img-fluid rounded mb-3" 
                                                 style="max-height: 200px;">
                                            <p class="text-muted small">Current image</p>
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center rounded mb-3" 
                                                 style="height: 200px;">
                                                <i class="fas fa-image fa-3x text-muted"></i>
                                            </div>
                                            <p class="text-muted small">No image uploaded</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="card mt-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Settings</h6>
                                    </div>
                                    <div class="card-body">
                                        <!-- Image Upload -->
                                        <div class="mb-3">
                                            <label class="form-label">Update Image</label>
                                            <input type="file" 
                                                   class="form-control @error('image') is-invalid @enderror" 
                                                   name="image" 
                                                   accept="image/*">
                                            <small class="text-muted">Upload new image to replace current one</small>
                                            @error('image')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Status -->
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       id="is_active" 
                                                       name="is_active" 
                                                       value="1" {{ old('is_active', $donation->is_active) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="is_active">
                                                    Active Status
                                                </label>
                                            </div>
                                            <small class="text-muted">Enable/disable this donation campaign</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="card mt-3">
                                    <div class="card-body text-center">
                                        <button type="submit" class="btn bg-gradient-success w-100 mb-2">
                                            <i class="fas fa-save me-1"></i> Update Donation
                                        </button>
                                        <a href="{{ route('admin.donations.index') }}" class="btn btn-outline-secondary w-100">
                                            <i class="fas fa-times me-1"></i> Cancel
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image preview functionality
    const imageInput = document.querySelector('input[name="image"]');
    if (imageInput) {
        imageInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Update current image preview
                    const currentImage = document.querySelector('.card img[alt="Current Donation Image"]');
                    if (currentImage) {
                        currentImage.src = e.target.result;
                    } else {
                        // Create new preview if no current image
                        const container = document.querySelector('.card-body.text-center');
                        const preview = document.createElement('img');
                        preview.src = e.target.result;
                        preview.className = 'img-fluid rounded mb-3';
                        preview.style.maxHeight = '200px';
                        container.innerHTML = '';
                        container.appendChild(preview);
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
@endsection