@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Create New Home Page Section</h1>
                    <a href="{{ route('admin.manage-home.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>

                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.manage-home.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <!-- Banner Image Upload -->
                            <div class="mb-4">
                                <label for="banner_img" class="form-label">Banner Image</label>
                                <input type="file" 
                                       class="form-control @error('banner_img') is-invalid @enderror" 
                                       id="banner_img" 
                                       name="banner_img" 
                                       accept="image/*">
                                @error('banner_img')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Supported formats: JPEG, PNG, JPG, GIF. Max size: 2MB
                                </small>
                            </div>

                            <!-- Section 1 -->
                            <div class="mb-4">
                                <label for="section_1" class="form-label">Section 1 Content</label>
                                <textarea class="form-control editor @error('section_1') is-invalid @enderror" 
                                          id="section_1" 
                                          name="section_1" 
                                          rows="8">{{ old('section_1') }}</textarea>
                                @error('section_1')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Section 2 -->
                            <div class="mb-4">
                                <label for="section_2" class="form-label">Section 2 Content</label>
                                <textarea class="form-control editor @error('section_2') is-invalid @enderror" 
                                          id="section_2" 
                                          name="section_2" 
                                          rows="8">{{ old('section_2') }}</textarea>
                                @error('section_2')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Section 3 -->
                            <div class="mb-4">
                                <label for="section_3" class="form-label">Section 3 Content</label>
                                <textarea class="form-control editor @error('section_3') is-invalid @enderror" 
                                          id="section_3" 
                                          name="section_3" 
                                          rows="8">{{ old('section_3') }}</textarea>
                                @error('section_3')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Section 4 -->
                            <div class="mb-4">
                                <label for="section_4" class="form-label">Section 4 Content</label>
                                <textarea class="form-control editor @error('section_4') is-invalid @enderror" 
                                          id="section_4" 
                                          name="section_4" 
                                          rows="8">{{ old('section_4') }}</textarea>
                                @error('section_4')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Section 5 -->
                            <div class="mb-4">
                                <label for="section_5" class="form-label">Section 5 Content</label>
                                <textarea class="form-control editor @error('section_5') is-invalid @enderror" 
                                          id="section_5" 
                                          name="section_5" 
                                          rows="8">{{ old('section_5') }}</textarea>
                                @error('section_5')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Status -->
                            <div class="mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           value="1" 
                                           id="status" 
                                           name="status" 
                                           {{ old('status', true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status">
                                        Active Status
                                    </label>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Create Section
                                </button>
                                <a href="{{ route('admin.manage-home.index') }}" class="btn btn-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Quill editors for each section
    const sections = ['section_1', 'section_2', 'section_3', 'section_4', 'section_5'];
    const editors = {};
    
    sections.forEach(function(sectionId) {
        const editorContainer = document.createElement('div');
        editorContainer.style.height = '200px';
        const textarea = document.getElementById(sectionId);
        textarea.style.display = 'none';
        textarea.parentNode.insertBefore(editorContainer, textarea);
        
        editors[sectionId] = new Quill(editorContainer, {
            theme: 'snow',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    [{ 'color': [] }, { 'background': [] }],
                    ['link', 'image'],
                    ['clean']
                ]
            }
        });
        
        // Set initial content
        if (textarea.value) {
            editors[sectionId].root.innerHTML = textarea.value;
        }
        
        // Update textarea on change
        editors[sectionId].on('text-change', function() {
            textarea.value = editors[sectionId].root.innerHTML;
        });
    });
    
    // Update textareas before form submission
    document.querySelector('form').addEventListener('submit', function() {
        sections.forEach(function(sectionId) {
            document.getElementById(sectionId).value = editors[sectionId].root.innerHTML;
        });
    });
});
</script>
@endpush
@endsection
