@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Member Details</h1>
                    <div>
                        <a href="{{ route('admin.members.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                        <form action="{{ route('admin.members.destroy', $member) }}" 
                              method="POST" 
                              class="d-inline"
                              onsubmit="return confirm('Are you sure you want to delete this member? This action cannot be undone.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash"></i> Delete Member
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Member Information -->
                <div class="row">
                    <!-- Personal Information -->
                    <div class="col-md-6 mb-4">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0"><i class="fas fa-user me-2"></i>Personal Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">Member Number:</th>
                                        <td><code>{{ $member->member_number ?? 'N/A' }}</code></td>
                                    </tr>
                                    <tr>
                                        <th>API Member ID:</th>
                                        <td><code>{{ $member->api_member_id ?? 'N/A' }}</code></td>
                                    </tr>
                                    <tr>
                                        <th>Full Name:</th>
                                        <td>
                                            <strong>{{ $member->title }} {{ $member->full_name }}</strong>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Email:</th>
                                        <td>
                                            {{ $member->email }}
                                            @if($member->email_verified)
                                                <i class="fas fa-check-circle text-success ms-1" title="Verified"></i>
                                            @else
                                                <i class="fas fa-times-circle text-danger ms-1" title="Not Verified"></i>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Mobile:</th>
                                        <td>
                                            {{ $member->mobile ?? 'N/A' }}
                                            @if($member->mobile_verified)
                                                <i class="fas fa-check-circle text-success ms-1" title="Verified"></i>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Date of Birth:</th>
                                        <td>{{ $member->date_of_birth ? $member->date_of_birth->format('F d, Y') : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Gender:</th>
                                        <td>{{ $member->gender ? ucfirst($member->gender) : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Nationality:</th>
                                        <td>{{ $member->nationality ?? 'N/A' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Membership Information -->
                    <div class="col-md-6 mb-4">
                        <div class="card h-100">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-id-card me-2"></i>Membership Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">Status:</th>
                                        <td>
                                            @if($member->status === 'active')
                                                <span class="badge bg-success">Active</span>
                                            @elseif($member->status === 'inactive')
                                                <span class="badge bg-secondary">Inactive</span>
                                            @elseif($member->status === 'suspended')
                                                <span class="badge bg-danger">Suspended</span>
                                            @else
                                                <span class="badge bg-secondary">{{ ucfirst($member->status) }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Tier:</th>
                                        <td>
                                            @if($member->tier)
                                                <span class="badge bg-info">{{ ucfirst($member->tier) }}</span>
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Points:</th>
                                        <td><strong>{{ number_format($member->points ?? 0) }}</strong></td>
                                    </tr>
                                    <tr>
                                        <th>Enrollment Date:</th>
                                        <td>{{ $member->enrollment_date ? $member->enrollment_date->format('F d, Y') : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Enrollment Channel:</th>
                                        <td>{{ $member->enrollment_channel ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Marketing Opt-in:</th>
                                        <td>
                                            @if($member->marketing_opt_in)
                                                <span class="badge bg-success">Yes</span>
                                            @else
                                                <span class="badge bg-secondary">No</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Last Login:</th>
                                        <td>{{ $member->last_login_at ? $member->last_login_at->format('M d, Y h:i A') : 'Never' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Last Synced:</th>
                                        <td>{{ $member->last_synced_at ? $member->last_synced_at->format('M d, Y h:i A') : 'N/A' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Address Information -->
                    <div class="col-md-12 mb-4">
                        <div class="card">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0"><i class="fas fa-map-marker-alt me-2"></i>Address Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="20%">Address Line 1:</th>
                                        <td>{{ $member->address_line1 ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Address Line 2:</th>
                                        <td>{{ $member->address_line2 ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>City:</th>
                                        <td>{{ $member->city ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>State/Region:</th>
                                        <td>{{ $member->state ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Country:</th>
                                        <td>{{ $member->country ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Postal Code:</th>
                                        <td>{{ $member->postal_code ?? 'N/A' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Tier Data (if exists) -->
                    @if($member->tier_data && is_array($member->tier_data) && count($member->tier_data) > 0)
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-warning text-dark">
                                <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Tier Data</h5>
                            </div>
                            <div class="card-body">
                                <pre class="mb-0 bg-light p-3 rounded">{{ json_encode($member->tier_data, JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Balances (if exists) -->
                    @if($member->balances && is_array($member->balances) && count($member->balances) > 0)
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-wallet me-2"></i>Balances</h5>
                            </div>
                            <div class="card-body">
                                <pre class="mb-0 bg-light p-3 rounded">{{ json_encode($member->balances, JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- System Information -->
                    <div class="col-md-12 mb-4">
                        <div class="card">
                            <div class="card-header bg-secondary text-white">
                                <h5 class="mb-0"><i class="fas fa-database me-2"></i>System Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="20%">Created At:</th>
                                        <td>{{ $member->created_at->format('F d, Y h:i A') }}</td>
                                    </tr>
                                    <tr>
                                        <th>Updated At:</th>
                                        <td>{{ $member->updated_at->format('F d, Y h:i A') }}</td>
                                    </tr>
                                    @if($member->deleted_at)
                                    <tr>
                                        <th>Deleted At:</th>
                                        <td class="text-danger">{{ $member->deleted_at->format('F d, Y h:i A') }}</td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <th>Has Valid Token:</th>
                                        <td>
                                            @if($member->hasValidToken())
                                                <span class="badge bg-success">Yes</span>
                                                <small class="text-muted">(Expires: {{ $member->token_expires_at->format('M d, Y h:i A') }})</small>
                                            @else
                                                <span class="badge bg-danger">No</span>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .table th {
        font-weight: 600;
        color: #6c757d;
    }
    code {
        background-color: #f8f9fa;
        padding: 2px 6px;
        border-radius: 3px;
        color: #d63384;
        font-size: 0.9em;
    }
    pre {
        font-size: 0.85em;
        max-height: 300px;
        overflow-y: auto;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
