@extends('layouts.admin')

@section('title', 'Edit Participating Hotel')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">Edit Participating Hotel</h5>
                            <p class="text-sm mb-0">
                                Update hotel information.
                            </p>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                                <a href="{{ route('admin.participating-hotels.index') }}" class="btn btn-outline-primary btn-sm mb-0 me-2">
                                    <i class="fas fa-arrow-left me-1"></i> Back to List
                                </a>
                                <a href="{{ route('admin.participating-hotels.show', $participatingHotel) }}" class="btn btn-outline-info btn-sm mb-0">
                                    <i class="fas fa-eye me-1"></i> View
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.participating-hotels.update', $participatingHotel) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">Hotel Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 mb-3">
                                                <label class="form-label">Hotel Title <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       class="form-control @error('title') is-invalid @enderror" 
                                                       name="title" 
                                                       value="{{ old('title', $participatingHotel->title) }}" 
                                                       placeholder="Enter hotel name">
                                                @error('title')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-3">
                                                <label class="form-label">Description</label>
                                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                                          name="description" 
                                                          rows="4" 
                                                          placeholder="Describe the hotel and its offerings">{{ old('description', $participatingHotel->description) }}</textarea>
                                                @error('description')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-3">
                                                <label class="form-label">Sort Order</label>
                                                <input type="number" 
                                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                                       name="sort_order" 
                                                       value="{{ old('sort_order', $participatingHotel->sort_order) }}" 
                                                       min="0" 
                                                       placeholder="Enter sort order (0 for first)">
                                                <small class="text-muted">Lower numbers appear first in the list</small>
                                                @error('sort_order')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Settings & Media -->
                            <div class="col-md-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">Current Image</h6>
                                    </div>
                                    <div class="card-body text-center">
                                        @if($participatingHotel->image)
                                            <img src="{{ Storage::url($participatingHotel->image) }}" 
                                                 alt="Current Hotel Image" 
                                                 class="img-fluid rounded mb-3" 
                                                 style="max-height: 200px;">
                                            <p class="text-muted small">Current image</p>
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center rounded mb-3" 
                                                 style="height: 200px;">
                                                <i class="fas fa-building fa-3x text-muted"></i>
                                            </div>
                                            <p class="text-muted small">No image uploaded</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="card mt-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Settings</h6>
                                    </div>
                                    <div class="card-body">
                                        <!-- Image Upload -->
                                        <div class="mb-3">
                                            <label class="form-label">Update Image</label>
                                            <input type="file" 
                                                   class="form-control @error('image') is-invalid @enderror" 
                                                   name="image" 
                                                   accept="image/*">
                                            <small class="text-muted">Upload new image to replace current one</small>
                                            @error('image')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Status -->
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       id="is_active" 
                                                       name="is_active" 
                                                       value="1" 
                                                       {{ old('is_active', $participatingHotel->is_active) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="is_active">
                                                    Active Status
                                                </label>
                                            </div>
                                            <small class="text-muted">Enable/disable this hotel in the list</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="card mt-3">
                                    <div class="card-body text-center">
                                        <button type="submit" class="btn bg-gradient-success w-100 mb-2">
                                            <i class="fas fa-save me-1"></i> Update Hotel
                                        </button>
                                        <a href="{{ route('admin.participating-hotels.index') }}" class="btn btn-outline-secondary w-100">
                                            <i class="fas fa-times me-1"></i> Cancel
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image preview functionality
    const imageInput = document.querySelector('input[name="image"]');
    if (imageInput) {
        imageInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Update current image preview
                    const currentImage = document.querySelector('.card img[alt="Current Hotel Image"]');
                    if (currentImage) {
                        currentImage.src = e.target.result;
                    } else {
                        // Create new preview if no current image
                        const container = document.querySelector('.card-body.text-center');
                        const preview = document.createElement('img');
                        preview.src = e.target.result;
                        preview.className = 'img-fluid rounded mb-3';
                        preview.style.maxHeight = '200px';
                        container.innerHTML = '';
                        container.appendChild(preview);
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
@endsection