@extends('layouts.admin')

@section('title', 'View Participating Hotel')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">{{ $participatingHotel->title }}</h5>
                            <p class="text-sm mb-0">
                                Participating Hotel Details
                            </p>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                                <a href="{{ route('admin.participating-hotels.index') }}" class="btn btn-outline-primary btn-sm mb-0 me-2">
                                    <i class="fas fa-arrow-left me-1"></i> Back to List
                                </a>
                                <a href="{{ route('admin.participating-hotels.edit', $participatingHotel) }}" class="btn bg-gradient-info btn-sm mb-0">
                                    <i class="fas fa-edit me-1"></i> Edit
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <!-- Hotel Overview -->
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">Hotel Details</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12 mb-4">
                                            <h4>{{ $participatingHotel->title }}</h4>
                                            @if($participatingHotel->is_active)
                                                <span class="badge bg-gradient-success">Active</span>
                                            @else
                                                <span class="badge bg-gradient-secondary">Inactive</span>
                                            @endif
                                        </div>

                                        @if($participatingHotel->description)
                                            <div class="col-12 mb-4">
                                                <h6>Description</h6>
                                                <p class="text-muted">{{ $participatingHotel->description }}</p>
                                            </div>
                                        @endif

                                        <!-- Sort Order Information -->
                                        <div class="col-12 mb-4">
                                            <h6>Display Information</h6>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="card bg-gradient-primary">
                                                        <div class="card-body text-white text-center">
                                                            <h3 class="mb-1">{{ $participatingHotel->sort_order }}</h3>
                                                            <p class="mb-0">Sort Order</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="card {{ $participatingHotel->is_active ? 'bg-gradient-success' : 'bg-gradient-secondary' }}">
                                                        <div class="card-body text-white text-center">
                                                            <h3 class="mb-1">
                                                                <i class="fas {{ $participatingHotel->is_active ? 'fa-check' : 'fa-times' }}"></i>
                                                            </h3>
                                                            <p class="mb-0">{{ $participatingHotel->is_active ? 'Active' : 'Inactive' }}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Hotel Timeline -->
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h6 class="mb-0">Hotel Timeline</h6>
                                </div>
                                <div class="card-body">
                                    <div class="timeline">
                                        <div class="timeline-item">
                                            <div class="timeline-marker bg-primary"></div>
                                            <div class="timeline-content">
                                                <h6 class="mb-1">Hotel Added</h6>
                                                <p class="text-muted text-sm mb-0">{{ $participatingHotel->created_at->format('M d, Y g:i A') }}</p>
                                            </div>
                                        </div>

                                        @if($participatingHotel->updated_at && $participatingHotel->updated_at != $participatingHotel->created_at)
                                            <div class="timeline-item">
                                                <div class="timeline-marker bg-info"></div>
                                                <div class="timeline-content">
                                                    <h6 class="mb-1">Last Updated</h6>
                                                    <p class="text-muted text-sm mb-0">{{ $participatingHotel->updated_at->format('M d, Y g:i A') }}</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <!-- Hotel Image -->
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">Hotel Image</h6>
                                </div>
                                <div class="card-body text-center">
                                    @if($participatingHotel->image)
                                        <img src="{{ Storage::url($participatingHotel->image) }}" 
                                             alt="{{ $participatingHotel->title }}" 
                                             class="img-fluid rounded mb-3" 
                                             style="max-height: 250px;">
                                    @else
                                        <div class="bg-light d-flex align-items-center justify-content-center rounded mb-3" 
                                             style="height: 250px;">
                                            <i class="fas fa-building fa-4x text-muted"></i>
                                        </div>
                                        <p class="text-muted">No image uploaded</p>
                                    @endif
                                </div>
                            </div>

                            <!-- Quick Stats -->
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h6 class="mb-0">Quick Stats</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6 text-center">
                                            <h5 class="mb-1">{{ $participatingHotel->sort_order }}</h5>
                                            <small class="text-muted">Sort Order</small>
                                        </div>
                                        <div class="col-6 text-center">
                                            <h5 class="mb-1">
                                                <i class="fas {{ $participatingHotel->is_active ? 'fa-check text-success' : 'fa-times text-secondary' }}"></i>
                                            </h5>
                                            <small class="text-muted">Status</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="text-center">
                                        <span class="badge {{ $participatingHotel->is_active ? 'bg-gradient-success' : 'bg-gradient-secondary' }} p-2">
                                            {{ $participatingHotel->is_active ? 'Active Hotel' : 'Inactive Hotel' }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Actions -->
                            <div class="card mt-3">
                                <div class="card-body text-center">
                                    <a href="{{ route('admin.participating-hotels.edit', $participatingHotel) }}" class="btn bg-gradient-info w-100 mb-2">
                                        <i class="fas fa-edit me-1"></i> Edit Hotel
                                    </a>

                                    <form action="{{ route('admin.participating-hotels.destroy', $participatingHotel) }}" method="POST" 
                                          onsubmit="return confirm('Are you sure you want to delete this hotel?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn bg-gradient-danger w-100">
                                            <i class="fas fa-trash me-1"></i> Delete Hotel
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding: 0;
    list-style: none;
}

.timeline-item {
    position: relative;
    padding-left: 30px;
    margin-bottom: 20px;
}

.timeline-item:not(:last-child)::before {
    content: '';
    position: absolute;
    left: 7px;
    top: 25px;
    height: calc(100% + 5px);
    width: 2px;
    background-color: #dee2e6;
}

.timeline-marker {
    position: absolute;
    left: 0;
    top: 5px;
    width: 14px;
    height: 14px;
    border-radius: 50%;
    border: 2px solid white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.timeline-content {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-left: 15px;
}
</style>
@endsection