@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Edit Point</h1>
                    <div>
                        <a href="{{ route('admin.points.show', $point) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                        <a href="{{ route('admin.points.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Points
                        </a>
                    </div>
                </div>

                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.points.update', $point) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row mb-3">
                        <div class="col-md-8">
                            <div class="card mb-3">
                                <div class="card-header">Basic Information</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $point->title) }}" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="slug" class="form-label">Slug</label>
                                        <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug', $point->slug) }}">
                                        <div class="form-text">Leave empty to auto-generate from title</div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="excerpt" class="form-label">Excerpt</label>
                                        <textarea class="form-control" id="excerpt" name="excerpt" rows="3">{{ old('excerpt', $point->excerpt) }}</textarea>
                                    </div>                                    <div class="mb-3">
                                        <label for="content" class="form-label">Content</label>
                                        <textarea class="form-control" id="content" name="content" rows="10">{{ old('content', $point->content) }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- Points Earning Content Section -->
                            <div class="card mb-3">
                                <div class="card-header">Points Earning Content</div>
                                <div class="card-body">
                                    <!-- Point Box 1 -->
                                    <div class="row mb-4">
                                        <div class="col-12">
                                            <h6 class="text-primary fw-bold mb-3">Point Box 1</h6>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="hotel_stays_title" class="form-label">Title</label>
                                            <input type="text" class="form-control" id="hotel_stays_title" name="hotel_stays_title" 
                                                   value="{{ old('hotel_stays_title', $point->hotel_stays_title ?? '') }}" 
                                                   placeholder="Enter title for Point Box 1">
                                            <div class="form-text">Title displayed above the content</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="hotel_stays_icon" class="form-label">Icon</label>
                                            <input type="text" class="form-control" id="hotel_stays_icon" name="hotel_stays_icon" 
                                                   value="{{ old('hotel_stays_icon', $point->hotel_stays_icon ?? '') }}" 
                                                   placeholder="fas fa-icon">
                                            <div class="form-text">FontAwesome icon class (e.g., fas fa-star)</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="hotel_stays_content" class="form-label">Content</label>
                                            <textarea class="form-control" id="hotel_stays_content" name="hotel_stays_content" rows="4" 
                                                      placeholder="Enter content for Point Box 1">{{ old('hotel_stays_content', $point->hotel_stays_content) }}</textarea>
                                            <div class="form-text">This content will be displayed in the Point Box 1 column</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="hotel_stays_link" class="form-label">Link</label>
                                            <input type="url" class="form-control" id="hotel_stays_link" name="hotel_stays_link" 
                                                   value="{{ old('hotel_stays_link', $point->hotel_stays_link ?? '') }}" 
                                                   placeholder="https://example.com">
                                            <div class="form-text">Optional link for Point Box 1 (include https://)</div>
                                        </div>
                                    </div>

                                    <!-- Point Box 2 -->
                                    <div class="row mb-4">
                                        <div class="col-12">
                                            <h6 class="text-primary fw-bold mb-3">Point Box 2</h6>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="dining_title" class="form-label">Title</label>
                                            <input type="text" class="form-control" id="dining_title" name="dining_title" 
                                                   value="{{ old('dining_title', $point->dining_title ?? '') }}" 
                                                   placeholder="Enter title for Point Box 2">
                                            <div class="form-text">Title displayed above the content</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="dining_icon" class="form-label">Icon</label>
                                            <input type="text" class="form-control" id="dining_icon" name="dining_icon" 
                                                   value="{{ old('dining_icon', $point->dining_icon ?? '') }}" 
                                                   placeholder="fas fa-icon">
                                            <div class="form-text">FontAwesome icon class (e.g., fas fa-star)</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="dining_content" class="form-label">Content</label>
                                            <textarea class="form-control" id="dining_content" name="dining_content" rows="4" 
                                                      placeholder="Enter content for Point Box 2">{{ old('dining_content', $point->dining_content) }}</textarea>
                                            <div class="form-text">This content will be displayed in the Point Box 2 column</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="dining_link" class="form-label">Link</label>
                                            <input type="url" class="form-control" id="dining_link" name="dining_link" 
                                                   value="{{ old('dining_link', $point->dining_link ?? '') }}" 
                                                   placeholder="https://example.com">
                                            <div class="form-text">Optional link for Point Box 2 (include https://)</div>
                                        </div>
                                    </div>

                                    <!-- Point Box 3 -->
                                    <div class="row mb-4">
                                        <div class="col-12">
                                            <h6 class="text-primary fw-bold mb-3">Point Box 3</h6>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="spa_title" class="form-label">Title</label>
                                            <input type="text" class="form-control" id="spa_title" name="spa_title" 
                                                   value="{{ old('spa_title', $point->spa_title ?? '') }}" 
                                                   placeholder="Enter title for Point Box 3">
                                            <div class="form-text">Title displayed above the content</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="spa_icon" class="form-label">Icon</label>
                                            <input type="text" class="form-control" id="spa_icon" name="spa_icon" 
                                                   value="{{ old('spa_icon', $point->spa_icon ?? '') }}" 
                                                   placeholder="fas fa-icon">
                                            <div class="form-text">FontAwesome icon class (e.g., fas fa-star)</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="spa_content" class="form-label">Content</label>
                                            <textarea class="form-control" id="spa_content" name="spa_content" rows="4" 
                                                      placeholder="Enter content for Point Box 3">{{ old('spa_content') }}</textarea>
                                            <div class="form-text">This content will be displayed in the Point Box 3 column</div>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <label for="spa_link" class="form-label">Link</label>
                                            <input type="url" class="form-control" id="spa_link" name="spa_link" 
                                                   value="{{ old('spa_link', $point->spa_link ?? '') }}" 
                                                   placeholder="https://example.com">
                                            <div class="form-text">Optional link for Point Box 3 (include https://)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Points Earning Image Section -->
                            <div class="card mb-3">
                                <div class="card-header">Points Earning Section Image</div>
                                <div class="card-body">
                                    @if($point->points_earning_image && Storage::disk('public')->exists($point->points_earning_image))
                                        <div class="mb-3">
                                            <label class="form-label">Current Image</label>
                                            <div class="current-image-preview">
                                                <img src="{{ Storage::url($point->points_earning_image) }}" 
                                                     alt="{{ $point->points_earning_image_alt ?? 'Points Earning Image' }}" 
                                                     class="img-thumbnail" style="max-width: 200px; max-height: 150px;">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="mb-3">
                                        <label for="points_earning_image" class="form-label">Points Earning Image</label>
                                        <input type="file" class="form-control" id="points_earning_image" name="points_earning_image">
                                        <div class="form-text">Image to display below the Points Earning Content section (Max: 2MB)</div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="points_earning_image_alt" class="form-label">Image Alt Text</label>
                                        <input type="text" class="form-control" id="points_earning_image_alt" name="points_earning_image_alt" 
                                               value="{{ old('points_earning_image_alt', $point->points_earning_image_alt ?? '') }}">
                                        <div class="form-text">Alternative text for the image (for accessibility)</div>
                                    </div>
                                </div>
                            </div>

                            <!-- SEO Section -->
                            <div class="card mb-3">
                                <div class="card-header">SEO Information</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="meta_title" class="form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ old('meta_title', $point->meta_title) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_description" class="form-label">Meta Description</label>
                                        <textarea class="form-control" id="meta_description" name="meta_description" rows="3">{{ old('meta_description', $point->meta_description) }}</textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                        <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $point->meta_keywords) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_robots" class="form-label">Meta Robots</label>
                                        <input type="text" class="form-control" id="meta_robots" name="meta_robots" value="{{ old('meta_robots', $point->meta_robots) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="canonical_url" class="form-label">Canonical URL</label>
                                        <input type="text" class="form-control" id="canonical_url" name="canonical_url" value="{{ old('canonical_url', $point->canonical_url) }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Publishing Options -->
                            <div class="card mb-3">
                                <div class="card-header">Publishing Options</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                        <select class="form-select" id="status" name="status">
                                            <option value="draft" {{ old('status', $point->status) == 'draft' ? 'selected' : '' }}>Draft</option>
                                            <option value="published" {{ old('status', $point->status) == 'published' ? 'selected' : '' }}>Published</option>
                                            <option value="archived" {{ old('status', $point->status) == 'archived' ? 'selected' : '' }}>Archived</option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="published_at" class="form-label">Publish Date</label>
                                        <input type="datetime-local" class="form-control" id="published_at" name="published_at" 
                                            value="{{ old('published_at', $point->published_at ? $point->published_at->format('Y-m-d\TH:i') : '') }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="sort_order" class="form-label">Sort Order</label>
                                        <input type="number" class="form-control" id="sort_order" name="sort_order" value="{{ old('sort_order', $point->sort_order) }}">
                                    </div>

                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured" value="1" 
                                            {{ old('is_featured', $point->is_featured) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_featured">Featured Point</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Media Options -->
                            <div class="card mb-3">
                                <div class="card-header">Featured Image</div>
                                <div class="card-body">
                                    @if($point->featured_image)
                                        <div class="mb-3">
                                            <label class="form-label">Current Image</label>
                                            <div class="mb-2">
                                                <img src="{{ asset('storage/' . $point->featured_image) }}" alt="{{ $point->featured_image_alt }}" 
                                                    class="img-thumbnail d-block" style="max-height: 150px;">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="mb-3">
                                        <label for="featured_image" class="form-label">Change Featured Image</label>
                                        <input type="file" class="form-control" id="featured_image" name="featured_image">
                                    </div>

                                    <div class="mb-3">
                                        <label for="featured_image_alt" class="form-label">Image Alt Text</label>
                                        <input type="text" class="form-control" id="featured_image_alt" name="featured_image_alt" 
                                            value="{{ old('featured_image_alt', $point->featured_image_alt) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="featured_image_caption" class="form-label">Image Caption</label>
                                        <input type="text" class="form-control" id="featured_image_caption" name="featured_image_caption" 
                                            value="{{ old('featured_image_caption', $point->featured_image_caption) }}">
                                    </div>
                                </div>
                            </div>

                            <!-- Banner Image -->
                            <div class="card mb-3">
                                <div class="card-header">Banner Image</div>
                                <div class="card-body">
                                    @if($point->banner_image)
                                        <div class="mb-3">
                                            <label class="form-label">Current Banner</label>
                                            <div class="mb-2">
                                                <img src="{{ asset('storage/' . $point->banner_image) }}" alt="{{ $point->banner_image_alt }}" 
                                                    class="img-thumbnail d-block" style="max-height: 150px;">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="mb-3">
                                        <label for="banner_image" class="form-label">Change Banner Image</label>
                                        <input type="file" class="form-control" id="banner_image" name="banner_image">
                                    </div>

                                    <div class="mb-3">
                                        <label for="banner_image_alt" class="form-label">Banner Alt Text</label>
                                        <input type="text" class="form-control" id="banner_image_alt" name="banner_image_alt" 
                                            value="{{ old('banner_image_alt', $point->banner_image_alt) }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Update Point</button>
                        <a href="{{ route('admin.points.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-generate slug from title
        const titleInput = document.getElementById('title');
        const slugInput = document.getElementById('slug');
        
        if (titleInput && slugInput && !slugInput.value) {
            titleInput.addEventListener('keyup', function() {
                slugInput.value = titleInput.value
                    .toLowerCase()
                    .replace(/[^a-z0-9\s-]/g, '')
                    .replace(/[\s-]+/g, '-')
                    .replace(/^-+|-+$/g, '');
            });
        }
    });
</script>
@endpush
