@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Points</h1>
                    <a href="{{ route('admin.points.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Points
                    </a>
                </div>

                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                @if($points->isEmpty())
                <div class="alert alert-info" role="alert">
                    No points found. Click the "Create Points" button to add one.
                </div>
                @else
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>                                    
                                <th>Title</th>
                                <th>Status</th>
                                <th>Sort Order</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($points as $point)
                            <tr>
                                <td>{{ $point->id }}</td>                                        <td>
                                    <a href="{{ route('admin.points.edit', $point) }}" class="text-decoration-none">
                                        {{ $point->title }}
                                    </a>
                                </td>
                                <td>
                                    <span class="badge {{ $point->status === 'published' ? 'bg-success' : ($point->status === 'draft' ? 'bg-warning' : 'bg-secondary') }}">
                                        {{ ucfirst($point->status) }}
                                    </span>
                                </td>
                                <td>{{ $point->sort_order }}</td>
                                <td>{{ $point->updated_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('admin.points.show', $point) }}" class="btn btn-sm btn-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.points.edit', $point) }}" class="btn btn-sm btn-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.points.destroy', $point) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this point?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $points->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
