@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Reward: {{ $reward->title }}</h1>
                    <div>
                        <a href="{{ route('admin.rewards.edit', $reward) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.rewards.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Rewards
                        </a>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="row mb-4">
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span>Reward Details</span>
                                <span class="badge {{ $reward->status == 'published' ? 'bg-success' : ($reward->status == 'draft' ? 'bg-warning' : 'bg-secondary') }}">
                                    {{ ucfirst($reward->status) }}
                                </span>
                            </div>
                            <div class="card-body">
                                @if($reward->featured_image || $reward->banner_image)
                                <div class="row mb-4">
                                    @if($reward->featured_image)
                                    <div class="col-md-6 mb-3">
                                        <h5>Featured Image</h5>
                                        <img src="{{ asset('storage/' . $reward->featured_image) }}" class="img-fluid rounded" 
                                            alt="{{ $reward->featured_image_alt }}">
                                        @if($reward->featured_image_caption)
                                        <p class="mt-2 text-muted">{{ $reward->featured_image_caption }}</p>
                                        @endif
                                    </div>
                                    @endif
                                    
                                    @if($reward->banner_image)
                                    <div class="col-md-6 mb-3">
                                        <h5>Banner Image</h5>
                                        <img src="{{ asset('storage/' . $reward->banner_image) }}" class="img-fluid rounded" 
                                            alt="{{ $reward->banner_image_alt }}">
                                    </div>
                                    @endif
                                </div>
                                <hr>
                                @endif

                                <h2>{{ $reward->title }}</h2>
                                
                                @if($reward->excerpt)
                                <div class="card bg-light mb-4">
                                    <div class="card-body">
                                        <h5>Excerpt</h5>
                                        <p class="mb-0">{{ $reward->excerpt }}</p>
                                    </div>
                                </div>
                                @endif

                                <div class="mt-4">
                                    <h5>Content</h5>
                                    <div class="content-preview">
                                        {!! $reward->content !!}
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Slug:</strong> {{ $reward->slug }}</p>
                                            <p><strong>Sort Order:</strong> {{ $reward->sort_order }}</p>
                                            <p>
                                                <strong>Featured:</strong> 
                                                @if($reward->is_featured)
                                                    <span class="badge bg-primary">Yes</span>
                                                @else
                                                    <span class="badge bg-secondary">No</span>
                                                @endif
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <p>
                                                <strong>Published Date:</strong> 
                                                {{ $reward->published_at ? $reward->published_at->format('d M Y, H:i') : 'Not set' }}
                                            </p>
                                            <p><strong>Created:</strong> {{ $reward->created_at->format('d M Y, H:i') }}</p>
                                            <p><strong>Last Updated:</strong> {{ $reward->updated_at->format('d M Y, H:i') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Author Info -->
                        <div class="card mb-4">
                            <div class="card-header">Author Information</div>
                            <div class="card-body">
                                <p><strong>Created By:</strong> {{ $reward->author->name ?? 'Unknown' }}</p>
                                <p><strong>Last Updated By:</strong> {{ $reward->updatedBy->name ?? 'Unknown' }}</p>
                            </div>
                        </div>

                        <!-- SEO Information -->
                        <div class="card mb-4">
                            <div class="card-header">SEO Information</div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong>Meta Title:</strong>
                                    <p class="mb-0">{{ $reward->meta_title ?: 'Not set' }}</p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Description:</strong>
                                    <p class="mb-0">{{ $reward->meta_description ?: 'Not set' }}</p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Keywords:</strong>
                                    <p class="mb-0">{{ $reward->meta_keywords ?: 'Not set' }}</p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Meta Robots:</strong>
                                    <p class="mb-0">{{ $reward->meta_robots ?: 'Not set' }}</p>
                                </div>
                                
                                <div class="mb-3">
                                    <strong>Canonical URL:</strong>
                                    <p class="mb-0">{{ $reward->canonical_url ?: 'Not set' }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="card">
                            <div class="card-header">Actions</div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <a href="{{ route('admin.rewards.edit', $reward) }}" class="btn btn-primary">
                                        <i class="fas fa-edit"></i> Edit Reward
                                    </a>
                                    <form action="{{ route('admin.rewards.destroy', $reward) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger w-100" 
                                            onclick="return confirm('Are you sure you want to delete this reward? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i> Delete Reward
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .content-preview img {
        max-width: 100%;
        height: auto;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
