@extends('layouts.pages')

@section('title', 'Our Charity Partners')

@section('meta_description',
    'Discover the charity organizations we support and partner with to make a positive impact
    in communities.')
@section('meta_keywords', 'charity, partners, giving back, community support, social responsibility')

@section('content')
    <div class="container my-5 pt-4">
        <!-- Header Section -->
        <section class="text-center mb-5 pt-lg-3 pt-md-4">
            <h1 class="display-4 fw-bold" style="margin-top:4rem">Driven by purpose. United by compassion</h1>
            <div class="lead mt-3 mb-5 w-75 mx-auto">
                We have partnered with Point for Good, an organization that supports various charities for their commitment
                to making the world a better place.
            </div>
        </section>

        @if ($charities->isNotEmpty())
            <!-- Charities Grid Section -->
            <section class="charities-grid py-5">
                <div class="row g-4">
                    @foreach ($charities as $charity)
                        <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-4">
                            <div class="card h-100 shadow-sm border-0 position-relative" style="transition: all 0.3s ease;">
                                <!-- Featured Badge -->
                                @if ($charity->is_featured)
                                    <div class="position-absolute top-0 end-0 m-3">
                                        <span class="badge bg-warning">Featured</span>
                                    </div>
                                @endif

                                <div class="card-body text-center d-flex flex-column p-4">
                                    <!-- Logo -->
                                    <div class="d-flex align-items-center justify-content-center mb-3"
                                        style="height: 120px;">
                                        @if ($charity->logo && Storage::disk('public')->exists($charity->logo))
                                            <img src="{{ Storage::url($charity->logo) }}"
                                                alt="{{ $charity->logo_alt ?? $charity->name }}" class="img-fluid"
                                                style="max-height: 100%; max-width: 100%; object-fit: contain;">
                                        @else
                                            <div
                                                class="d-flex align-items-center justify-content-center bg-light rounded w-100 h-100">
                                                <i class="fas fa-heart fa-3x text-muted"></i>
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Name -->
                                    <h4 class="card-title h5 fw-bold text-dark mb-3">{{ $charity->name }}</h4>

                                    <!-- Description -->
                                    @if ($charity->description)
                                        <p class="card-text text-muted small mb-3 flex-grow-1">
                                            {{ Str::limit($charity->description, 120) }}
                                        </p>
                                    @endif

                                    <!-- Website Link -->
                                    @if ($charity->website_url)
                                        <div class="mt-auto">
                                            <a href="{{ $charity->website_url }}" target="_blank" rel="noopener"
                                                class="btn ct-btn-white btn-sm">
                                                Discover More <i class="fas fa-external-link-alt ms-1"></i>
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </section>
        @else
            <!-- No Charities Message -->
            <section class="no-charities py-5">
                <div class="row justify-content-center">
                    <div class="col-lg-6 text-center">
                        <div class="bg-light rounded p-5">
                            <i class="fas fa-heart fa-4x text-muted mb-4"></i>
                            <h3 class="mb-3">No Charity Partners Yet</h3>
                            <p class="text-muted">
                                We're currently working on establishing partnerships with charity organizations.
                                Please check back soon to see our amazing charity partners!
                            </p>
                        </div>
                    </div>
                </div>
            </section>
        @endif
    </div>

    <div class="text-center mt-5 mb-5">
        <a href="https://thelalitloyalty.in" target="_blank" class="btn ct-btn-white btn-lg">
            Sign In To Donate<i class="fas fa-arrow-right ms-2"></i>
        </a>
    </div>

    <style>
        /* Hover effect for charity cards */
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1) !important;
        }

        /* Custom button colors to match brand */
        .btn-outline-primary {
            border-color: #b18645;
            color: #b18645;
        }

        .btn-outline-primary:hover {
            background-color: #b18645;
            border-color: #b18645;
            color: white;
        }
    </style>
@endsection
