<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Email Verification OTP - The Lalit Loyalty</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Arial', sans-serif;
      background-color: #f4f4f4;
    }

    .email-container {
      max-width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
    }

    .header {
      background-color: #d4a574;
      padding: 30px 20px;
      text-align: center;
    }

    .header img {
      max-width: 200px;
      height: auto;
    }

    .header h1 {
      color: #ffffff;
      margin: 15px 0 0 0;
      font-size: 24px;
      font-weight: 600;
    }

    .content {
      padding: 40px 30px;
      color: #333333;
      line-height: 1.6;
    }

    .content h2 {
      color: #d4a574;
      font-size: 22px;
      margin-top: 0;
    }

    .content p {
      margin: 15px 0;
      font-size: 15px;
    }

    .otp-box {
      background: linear-gradient(135deg, #d4a574 0%, #c6996b 100%);
      padding: 30px;
      margin: 25px 0;
      text-align: center;
      border-radius: 10px;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .otp-box h3 {
      color: #ffffff;
      margin: 0 0 15px 0;
      font-size: 16px;
      font-weight: normal;
      text-transform: uppercase;
      letter-spacing: 1px;
    }

    .otp-code {
      background-color: #ffffff;
      color: #d4a574;
      font-size: 36px;
      font-weight: bold;
      padding: 20px 30px;
      border-radius: 8px;
      letter-spacing: 8px;
      display: inline-block;
      font-family: 'Courier New', monospace;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .otp-validity {
      background-color: #fff3e0;
      border-left: 4px solid #ff9800;
      padding: 15px 20px;
      margin: 20px 0;
      border-radius: 4px;
    }

    .otp-validity p {
      margin: 0;
      color: #e65100;
      font-size: 14px;
      font-weight: 600;
    }

    .security-note {
      background-color: #f9f9f9;
      border: 1px solid #e0e0e0;
      padding: 20px;
      margin: 25px 0;
      border-radius: 5px;
    }

    .security-note h4 {
      color: #d4a574;
      margin-top: 0;
      font-size: 16px;
    }

    .security-note ul {
      margin: 10px 0;
      padding-left: 20px;
      font-size: 14px;
      color: #666666;
    }

    .security-note li {
      margin: 8px 0;
    }

    .footer {
      background-color: #f9f9f9;
      padding: 30px 20px;
      text-align: center;
      border-top: 1px solid #e0e0e0;
    }

    .footer p {
      margin: 8px 0;
      font-size: 13px;
      color: #777777;
    }

    .footer a {
      color: #d4a574;
      text-decoration: none;
    }

    .divider {
      height: 1px;
      background-color: #e0e0e0;
      margin: 30px 0;
    }
  </style>
</head>

<body>
  <div class="email-container">
    <!-- Header -->
    <div class="header">
      <img src="{{ asset('images/logo.png') }}" alt="The Lalit Loyalty Logo">
      <h1>Email Verification</h1>
    </div>

    <!-- Content -->
    <div class="content">
      <h2>Verify Your Email Address</h2>
      
      <p>Hello,</p>
      
      <p>Thank you for registering with The Lalit Loyalty Program. To complete your registration and verify your email address, please use the One-Time Password (OTP) below:</p>

      <!-- OTP Box -->
      <div class="otp-box">
        <h3>Your Verification Code</h3>
        <div class="otp-code">{{ $otp }}</div>
      </div>

      <!-- Validity Notice -->
      <div class="otp-validity">
        <p>⏱️ This OTP is valid for 10 minutes only.</p>
      </div>

      <p>Enter this OTP on the registration page to verify your email address and continue with the signup process.</p>

      <div class="divider"></div>

      <!-- Security Note -->
      <div class="security-note">
        <h4>🔒 Security Tips</h4>
        <ul>
          <li>Never share this OTP with anyone, including our staff</li>
          <li>This OTP is only for email verification on {{ config('app.name') }}</li>
          <li>If you didn't request this verification, please ignore this email</li>
          <li>The OTP will expire automatically after 10 minutes</li>
        </ul>
      </div>

      <p>If you're having trouble with verification or didn't request this OTP, please contact our support team.</p>

      <p>Welcome to The Lalit Loyalty family!</p>

      <p style="margin-top: 30px;">
        <strong>Best regards,</strong><br>
        The Lalit Loyalty Team
      </p>
    </div>

    <!-- Footer -->
    <div class="footer">
      <p><strong>The Lalit Loyalty Program</strong></p>
      <p>This is an automated email. Please do not reply to this message.</p>
      <p>
        <a href="{{ config('app.url') }}">Visit Our Website</a> | 
        <a href="{{ config('app.url') }}/contact">Contact Support</a>
      </p>
      <p style="margin-top: 20px; font-size: 12px; color: #999999;">
        © {{ date('Y') }} The Lalit Hotels. All rights reserved.
      </p>
    </div>
  </div>
</body>

</html>
