<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Welcome to The Lalit Loyalty</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Arial', sans-serif;
      background-color: #f4f4f4;
    }

    .email-container {
      max-width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
    }

    .header {
      background-color: #d4a574;
      padding: 30px 20px;
      text-align: center;
    }

    .header img {
      max-width: 200px;
      height: auto;
    }

    .header h1 {
      color: #ffffff;
      margin: 15px 0 0 0;
      font-size: 24px;
      font-weight: 600;
    }

    .content {
      padding: 40px 30px;
      color: #333333;
      line-height: 1.6;
    }

    .content h2 {
      color: #d4a574;
      font-size: 22px;
      margin-top: 0;
    }

    .content p {
      margin: 15px 0;
      font-size: 15px;
    }

    .credentials-box {
      background-color: #f9f9f9;
      border-left: 4px solid #d4a574;
      padding: 20px;
      margin: 25px 0;
    }

    .credentials-box h3 {
      color: #d4a574;
      margin-top: 0;
      font-size: 18px;
    }

    .credential-item {
      margin: 12px 0;
      font-size: 15px;
    }

    .credential-label {
      font-weight: bold;
      color: #555555;
      display: inline-block;
      width: 120px;
    }

    .credential-value {
      color: #333333;
      font-family: 'Courier New', monospace;
      background-color: #ffffff;
      padding: 4px 8px;
      border-radius: 3px;
    }

    .button {
      display: inline-block;
      background-color: #d4a574;
      color: #ffffff;
      text-decoration: none;
      padding: 14px 35px;
      border-radius: 5px;
      font-size: 16px;
      font-weight: 600;
      margin: 20px 0;
    }

    .button:hover {
      background-color: #c08d5a;
    }

    .benefits {
      background-color: #f9f9f9;
      padding: 20px;
      margin: 25px 0;
      border-radius: 5px;
    }

    .benefits h3 {
      color: #d4a574;
      margin-top: 0;
    }

    .benefits ul {
      margin: 10px 0;
      padding-left: 20px;
    }

    .benefits li {
      margin: 8px 0;
      color: #555555;
    }

    .footer {
      background-color: #2c2c2c;
      color: #ffffff;
      padding: 30px 20px;
      text-align: center;
    }

    .footer p {
      margin: 8px 0;
      font-size: 13px;
      color: #cccccc;
    }

    .footer a {
      color: #d4a574;
      text-decoration: none;
    }

    .footer a:hover {
      text-decoration: underline;
    }

    .social-links {
      margin: 20px 0 15px 0;
    }

    .social-links a {
      display: inline-block;
      margin: 0 10px;
      color: #d4a574;
      text-decoration: none;
      font-size: 14px;
    }

    .divider {
      border: 0;
      border-top: 1px solid #e0e0e0;
      margin: 25px 0;
    }

    @media only screen and (max-width: 600px) {
      .content {
        padding: 30px 20px;
      }

      .credential-label {
        display: block;
        margin-bottom: 5px;
      }
    }
  </style>
</head>

<body>
  <div class="email-container">
    <!-- Header -->
    <div class="header">
      <h1>The Lalit Loyalty Program</h1>
    </div>

    <!-- Content -->
    <div class="content">
      <h2>Welcome, {{ $member->first_name }}!</h2>

      <p>Congratulations! Your membership with The Lalit Loyalty Program has been successfully created. We are thrilled
        to have you as part of our exclusive community.</p>

      <!-- Credentials Box -->
      <div class="credentials-box">
        <h3>Your Membership Details</h3>
        <div class="credential-item">
          <span class="credential-label">Member ID:</span>
          <span class="credential-value">{{ $member->member_number ?? $member->api_member_id }}</span>
        </div>
        <div class="credential-item">
          <span class="credential-label">Email:</span>
          <span class="credential-value">{{ $member->email }}</span>
        </div>
        <div class="credential-item">
          <span class="credential-label">Mobile:</span>
          <span class="credential-value">{{ $member->mobile }}</span>
        </div>
        <div class="credential-item">
          <span class="credential-label">Member Since:</span>
          <span
            class="credential-value">{{ $member->enrollment_date ? \Carbon\Carbon::parse($member->enrollment_date)->format('F d, Y') : now()->format('F d, Y') }}</span>
        </div>
      </div>

      <p>Please keep these credentials safe and secure. You'll need them to access your account and enjoy all the
        exclusive benefits of your membership.</p>

      <p
        style="background-color: #fff3cd; border-left: 4px solid #d4a574; padding: 15px; margin: 20px 0; border-radius: 3px;">
        <strong>First Time Login:</strong> Since this is your first time, you'll need to set up your password. Please
        use the <strong>"Forgot Password"</strong> option on the login page to create your secure password. You'll
        receive a OTP on your registered mobile no.
      </p>

      <hr class="divider">

      <!-- Benefits Section -->
      <div class="benefits">
        <h3>Your Membership Benefits</h3>
        <ul>
          <li>Earn points on every stay and transaction</li>
          <li>Exclusive member-only offers and promotions</li>
          <li>Priority reservations and special rates</li>
          <li>Complimentary upgrades (subject to availability)</li>
          <li>Access to member events and experiences</li>
          <li>Birthday and anniversary special treats</li>
        </ul>
      </div>

      <p>Start exploring your benefits by logging into your account. Our concierge team is always ready to assist you
        with any questions.</p>

      <p>Thank you for choosing The Lalit. We look forward to creating memorable experiences for you!</p>

      <p style="margin-top: 30px;">
        <strong>Warm regards,</strong><br>
        The Lalit Loyalty Team
      </p>
    </div>

    <!-- Footer -->
    <div class="footer">
      <p><strong>The Lalit Hotels</strong></p>

      {{-- <div class="social-links">
        <a href="https://www.facebook.com/TheLaLiTHotels">Facebook</a> |
        <a href="https://twitter.com/TheLaLiTHotels">Twitter</a> |
        <a href="https://www.instagram.com/thelalithotels">Instagram</a>
      </div> --}}

      <p>
        <a href="{{ url('/') }}">Visit Our Website</a> |
        <a href="{{ url('/contact') }}">Contact Us</a> |
        <a href="{{ url('/offers-detail') }}">Offers Details</a>
      </p>

      <p style="margin-top: 20px; font-size: 12px; color: #999999;">
        This is an automated email. Please do not reply to this message.<br>
        If you have any questions, please contact us at <a href="mailto:loyalty@thelalit.com">loyalty@thelalit.com</a>
      </p>

      <p style="margin-top: 15px; font-size: 11px; color: #888888;">
        &copy; {{ date('Y') }} The Lalit Hotels. All rights reserved.
      </p>
    </div>
  </div>
</body>

</html>