@extends('layouts.membership')

@section('title', 'Dashboard - The LaLiT Loyalty')

@section('content')
<div class="container px-4 py-5 dashboard-wrapper">
  <!-- Welcome Header -->
  <div class="row mb-5">
    <div class="col-12 text-center loyalty-header-label">
      <h1 class="display-6 mb-4">
        Welcome to The Lalit Loyalty, {{ $membershipUser['name'] ?? 'Member' }}
      </h1>
      <div class="line"></div>

    </div>
  </div>
  <!-- Membership Info Bar -->
  <div class="row mb-4 section-one-wrapper">
    <div class="col-12">
      <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center py-3 px-4 gap-3">
        <div>
          <small class="text-muted d-block mb-1">Membership Number</small>
          <strong style="font-size: 1.1rem; color: #333;">{{ $membershipUser['membership_number'] ?? '2007513951'
            }}</strong>
        </div>
        <div class="d-flex flex-column flex-md-row gap-2 gap-md-4 align-items-start align-items-md-center">
          <a href="{{ route('membership.edit-profile') }}"
            class="btn-link p-0 d-flex align-items-center position-relative"
            style="color: #666; font-size: 0.9rem; font-weight: 500;">
            <span class="position-relative me-2">
              <i class="fas fa-user-cog"></i>
              <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger"
                style="font-size: 0.6rem; padding: 0.2rem 0.4rem;">
                1
              </span>
            </span>
            My Profile
          </a>
          {{-- <a href="{{ route('membership.myrewards') }}"
            class="btn-link p-0 d-flex align-items-center"
            style="color: #666; font-size: 0.9rem; font-weight: 500;">
            <i class="fas fa-gift me-2"></i>
            MY REWARDS
          </a> --}}
          <a href="{{ route('membership.statement') }}"
            class="btn-link p-0 d-flex align-items-center"
            style="color: #666; font-size: 0.9rem; font-weight: 500;">
            <i class="fas fa-file-alt me-2"></i>
            My Account
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Points Balance Section -->
  <div class="row justify-content-center mb-5">
    <div class="col-12">
      <div class="row g-4">
        <!-- Jumeirah One Points Balance -->
        <div class="col-12 col-md-4 points-balance-card">
          <div class="card border-0 h-100">
            <div class="card-body text-center py-4 py-md-5">
              <h5 class="mb-3 mb-md-4" style="color: #333;">The Lalit Loyalty Points balance</h5>
              <h1 class="display-2 display-md-1 mb-3" style="font-weight: 300; color: #333;">{{ $totalPoints ?? '0' }}</h1>
              <p class="text-muted mb-3 mb-md-4">
                Available The Lalit Loyalty balance
                <i class="fas fa-info-circle ms-1"></i>
              </p>
              <a class="btn-link px-4" href="{{ route('membership.exchange-points') }}" style="color: #666;">Redeem Points</a>
            </div>
          </div>
        </div>

        <!-- Tier Points Balance -->
        <div class="col-12 col-md-4 tier-points-card">
          <div class="card border-0 h-100">
            <div class="card-body text-center py-4 py-md-5">
              <h5 class="mb-3 mb-md-4" style="color: #333;">Tier Status</h5>

              <!-- Tier Progress Indicators -->
              <div class="mb-3 mb-md-4">
                @php
                  // Define tier order and colors
                  $tiers = [
                    'BLUE' => ['color' => '#4169E1', 'order' => 1],
                    'SILVER' => ['color' => '#c0c0c0', 'order' => 2], 
                    'GOLD' => ['color' => '#d4af37', 'order' => 3],
                    'PLATINUM' => ['color' => '#708090', 'order' => 4]
                  ];
                  
                  // Get current member tier from tier_data or fallback to tier column
                  $currentTier = 'BLUE'; // default
                  $tierStartDate = null;
                  $tierEndDate = null;
                  
                  if (isset($membershipUser['tier_data']) && is_array($membershipUser['tier_data']) && !empty($membershipUser['tier_data'])) {
                    $currentTierData = $membershipUser['tier_data'][0] ?? [];
                    $currentTier = $currentTierData['tier_code_id'] ?? $membershipUser['tier'] ?? 'BLUE';
                    $tierStartDate = $currentTierData['tier_start_date'] ?? null;
                    $tierEndDate = $currentTierData['tier_end_date'] ?? null;
                  } else {
                    $currentTier = $membershipUser['tier'] ?? 'BLUE';
                  }
                  
                  $currentTierOrder = $tiers[strtoupper($currentTier)]['order'] ?? 1;
                  $currentTierColor = $tiers[strtoupper($currentTier)]['color'] ?? '#4169E1';
                @endphp
                
                <div class="d-flex justify-content-center align-items-center gap-2 gap-md-4 mb-3 flex-wrap">
                  @foreach($tiers as $tierName => $tierInfo)
                    @php
                      $isActive = $tierInfo['order'] <= $currentTierOrder;
                      $isCurrent = strtoupper($currentTier) === $tierName;
                    @endphp
                    <div class="text-center">
                      <div class="rounded-circle d-flex align-items-center justify-content-center mb-2 position-relative {{ $isCurrent ? 'tier-current' : '' }}"
                        style="width: 35px; height: 35px; background-color: {{ $isActive ? $tierInfo['color'] : '#e9ecef' }}; {{ $isCurrent ? 'box-shadow: 0 0 0 3px ' . $currentTierColor . '33;' : '' }}">
                        @if($isCurrent)
                          <i class="fas fa-crown" style="color: white; font-size: 12px;"></i>
                        @elseif($isActive)
                          <i class="fas fa-check" style="color: white; font-size: 12px;"></i>
                        @endif
                      </div>
                      <small style="color: {{ $isActive ? $tierInfo['color'] : '#6c757d' }}; font-weight: {{ $isCurrent ? '600' : ($isActive ? '500' : 'normal') }}; font-size: 0.75rem;">
                        {{ $tierName }}
                      </small>
                    </div>
                  @endforeach
                </div>
                
                @php
                  // Calculate tier progress message
                  $progressMessage = "Spend an additional USD 2,500 to collect 5,000 Tier Points to become a Silver member";
                  
                  if (strtoupper($currentTier) === 'SILVER') {
                    $progressMessage = "Spend an additional USD 5,000 to collect 10,000 Tier Points to become a Gold member";
                  } elseif (strtoupper($currentTier) === 'GOLD') {
                    $progressMessage = "Spend an additional USD 10,000 to collect 20,000 Tier Points to become a Platinum member";
                  } elseif (strtoupper($currentTier) === 'PLATINUM') {
                    $progressMessage = "Congratulations! You have achieved the highest tier status.";
                  }
                @endphp
                
                <p class="mb-0" style="color: {{ $currentTierColor }}; font-weight: 600;">
                  <strong>Current Tier: {{ strtoupper($currentTier) }}</strong>
                  @if($tierEndDate)
                    <br><small class="text-muted">Valid until {{ date('M d, Y', strtotime($tierEndDate)) }}</small>
                  @endif
                </p>
              </div>

              <p class="text-muted mb-3 mb-md-4" style="font-size: 0.9rem;">
                {{ $progressMessage }}
              </p>
              <a class="btn-link px-4" href="{{ url('/package-details') }}" style="color: #666;">MEMBER BENEFITS</a>
            </div>
          </div>
        </div>

        <!-- E-Card Section -->
        <div class="col-12 col-md-4 membership-card">
          <div class="card border-0 h-100">
            <div class="card-body text-center py-4 py-md-5">
              <div class="mb-3 d-flex justify-content-center">
                @php
                  // Get current tier and determine card image
                  $currentTierCode = strtolower($currentTier ?? 'blue');
                  $cardImage = 'blue-card.png'; // default
                  
                  // Map tier to card image
                  $tierImages = [
                    'blue' => 'blue-card.png',
                    'silver' => 'silver-card.png',
                    'gold' => 'gold-card.png',
                    'platinum' => 'platinum-card.png'
                  ];
                  
                  if (isset($tierImages[$currentTierCode])) {
                    $cardImage = $tierImages[$currentTierCode];
                  }
                @endphp
                <div class="position-relative" style="max-width: 180px; width: 70%; margin-top: 1rem;">
                  <img src="{{ asset('assets/images/' . $cardImage) }}" alt="{{ ucfirst($currentTierCode) }} Membership Card" class="img-fluid">
                  <div class="position-absolute bottom-0 start-0 w-100 text-white px-3 pb-2" style="font-size: 0.75rem; font-weight: 600; letter-spacing: 1px;">
                    {{ $membershipUser['membership_number'] ?? '2007513951' }}
                  </div>
                </div>
              </div>
              <a href="{{ route('membership.manage-card') }}" class="btn-link" style="color: #666;">
                YOUR E-CARD
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


</div>
@endsection