@extends('layouts.membership')

@section('title', 'Manage Card - The LaLiT Loyalty')

@section('content')
<div class="container px-4 py-5 dashboard-wrapper">
  <!-- Header Section -->
  <div class="row mb-5">
    <div class="col-12">
      <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="flex-grow-1 text-center">
          <h1 class="display-6 mb-4">
            Manage Card
          </h1>
          <div class="line"></div>
        </div>
        <div>
          <a href="{{ route('membership.dashboard') }}" class="btn back-to-dashboard-btn">
            <i class="fas fa-arrow-left me-2"></i>BACK TO DASHBOARD
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Content Section -->
  <div class="row justify-content-center">
    <div class="col-lg-10">
      <div class="card border-0 manage-card-section" style="background-color: #f5f0eb;">
        <div class="card-body p-5">
          <div class="row">
            <!-- Left Column - Card Info -->
            <div class="col-md-7">
              <div class="manage-card-content">
                @php
                  // Get tier name for display
                  $tierName = ucfirst(strtolower($currentTier ?? 'Blue'));
                @endphp
                <h3 class="manage-card-title mb-4">
                  Your LaLiT Loyalty {{ $tierName }} card is your ticket to<br>
                  ultimate rewards & benefits
                </h3>
                <p class="manage-card-description mb-4">
                  Your LaLiT Loyalty {{ $tierName }} membership card entitles you to exclusive member benefits, privileges and rewards when you stay, dine or relax with The LaLiT Hotels.
                </p>

                <!-- Card Details Section -->
                <div class="card-details-section mb-4">
                  <div class="row">
                    <div class="col-md-6 mb-3">
                      <div class="card-detail-item">
                        <label class="card-detail-label">CARD NUMBER</label>
                        <div class="card-detail-value">{{ $membershipUser['membership_number'] ?? '2007513951' }}</div>
                      </div>
                    </div>
                    <div class="col-md-6 mb-3">
                      <div class="card-detail-item">
                        <label class="card-detail-label">CARD HOLDER NAME</label>
                        <div class="card-detail-value">{{ strtoupper($membershipUser['name'] ?? 'MEMBER NAME') }}</div>
                      </div>
                    </div>
                  </div>
                </div>

                <!-- Action Links -->
                <div class="manage-card-actions">
                    Print or add card to device
                </div>

                <!-- Card Options -->
                <div class="card-options mt-4">
                  <div class="row g-3">
                    <div class="col-3">
                      <div class="card-option-item text-center" data-option="print">
                        <a title="Print your membership card" href="#"><i class="fa-solid fa-print fa-2x mb-2"></i></a>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="card-option-item text-center" data-option="apple-wallet">
                        <a href="#" title="Add your membership card to Apple Wallet"><i class="fas fa-apple-alt fa-2x mb-2"></i></a>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="card-option-item text-center" data-option="android-wallet">
                        <a href="#" title="Add your membership card to Android Wallet"> <i class="fa-brands fa-android fa-2x mb-2"></i></a>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="card-option-item text-center" data-option="download">
                        <a href="#" title="Download your membership card"><i class="fas fa-download fa-2x mb-2"></i></a>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Right Column - Card Image -->
            <div class="col-md-5">
              <div class="manage-card-visual text-center">
                <div class="membership-card-display">
                  @php
                    // Get current tier and determine card image
                    $currentTier = 'BLUE'; // default
                    
                    // Get tier from tier_data or fallback to tier column
                    if (isset($membershipUser['tier_data']) && is_array($membershipUser['tier_data']) && !empty($membershipUser['tier_data'])) {
                      $currentTierData = $membershipUser['tier_data'][0] ?? [];
                      $currentTier = $currentTierData['tier_code_id'] ?? $membershipUser['tier'] ?? 'BLUE';
                    } elseif (isset($membershipUser['tier'])) {
                      $currentTier = $membershipUser['tier'];
                    }
                    
                    $currentTierCode = strtolower($currentTier);
                    $cardImage = 'blue-card.png'; // default
                    
                    // Map tier to card image
                    $tierImages = [
                      'blue' => 'blue-card.png',
                      'silver' => 'silver-card.png',
                      'gold' => 'gold-card.png',
                      'platinum' => 'platinum-card.png'
                    ];
                    
                    if (isset($tierImages[$currentTierCode])) {
                      $cardImage = $tierImages[$currentTierCode];
                    }
                  @endphp
                  <img src="{{ asset('assets/images/' . $cardImage) }}" alt="{{ ucfirst($currentTierCode) }} LaLiT Loyalty Card" class="img-fluid membership-card-img">
                  <div class="card-overlay-info">
                    <div class="card-number">{{ $membershipUser['membership_number'] }}</div>
                    <div class="card-name">{{ strtoupper($membershipUser['name']) }}</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Print card functionality
    const printCardBtn = document.getElementById('printCardBtn');
    if (printCardBtn) {
        printCardBtn.addEventListener('click', function(e) {
            e.preventDefault();
            // Open print dialog or show options
            showCardOptions();
        });
    }

    // Card option clicks
    const cardOptions = document.querySelectorAll('.card-option-item');
    cardOptions.forEach(option => {
        option.addEventListener('click', function() {
            const optionType = this.getAttribute('data-option');
            handleCardOption(optionType);
        });
    });

    function showCardOptions() {
        // Show the card options section
        const cardOptions = document.querySelector('.card-options');
        cardOptions.scrollIntoView({ behavior: 'smooth' });
    }

    function handleCardOption(type) {
        switch(type) {
            case 'apple-wallet':
                // Add to Apple Wallet functionality
                alert('Add to Apple Wallet functionality would be implemented here');
                break;
            case 'google-pay':
                // Add to Google Pay functionality
                alert('Add to Google Pay functionality would be implemented here');
                break;
            case 'samsung-pay':
                // Add to Samsung Pay functionality
                alert('Add to Samsung Pay functionality would be implemented here');
                break;
            case 'print':
                // Print card functionality
                window.print();
                break;
            default:
                console.log('Unknown card option:', type);
        }
    }
});
</script>
@endpush
@endsection
