@extends('layouts.pages')

@section('title', $reward->meta_title ?? $reward->title . ' - The LaLiT Rewards')

@section('nav-portfolio', 'active')

@section('hero')
<!-- Hero Banner with Reward Image -->
<div class="hero-banner position-relative">
    <div class="hero-image">
        @if($reward->banner_image)
            <img src="{{ asset('storage/' . $reward->banner_image) }}" 
                 class="w-100" alt="{{ $reward->banner_image_alt ?? $reward->title }}" 
                 style="height: 38.563rem; object-fit: cover;">
        @elseif($reward->featured_image)
            <img src="{{ asset('storage/' . $reward->featured_image) }}" 
                 class="w-100" alt="{{ $reward->featured_image_alt ?? $reward->title }}" 
                 style="height: 38.563rem; object-fit: cover;">
        @else
            <img src="{{ asset('assets/images/hero-bg.avif') }}"
                 class="w-100" alt="Hero Background" style="height: 38.563rem; object-fit: cover;">
        @endif
    </div>
    <!-- Hero Overlay -->
    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100"
         style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.6) 100%);">
    </div>
    
    <!-- Hero Content -->
    <div class="hero-content position-absolute top-50 start-50 translate-middle text-center text-white">
        <h1 class="display-4 fw-bold">{{ $reward->title }}</h1>
        @if($reward->excerpt)
            <p class="lead mt-3">{{ $reward->excerpt }}</p>
        @endif
    </div>
</div>
@endsection

@section('page_nav_items')
<li class="nav-item">
    <a class="nav-link px-3" href="#overview">Overview</a>
</li>
<li class="nav-item">
    <a class="nav-link px-3" href="#details">Details</a>
</li>
<li class="nav-item">
    <a class="nav-link px-3" href="#terms">Terms & Conditions</a>
</li>
@endsection

@section('content')
<!-- Reward Content Section -->
<section id="overview" class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <!-- Reward Content -->
                <div class="reward-content bg-white shadow-sm rounded p-4 mb-5">
                    @if($reward->excerpt)
                        <div class="lead mb-4 fs-5 fw-semibold text-center">
                            {{ $reward->excerpt }}
                        </div>
                        <hr class="my-4">
                    @endif
                    
                    <div id="details" class="reward-details">
                        {!! $reward->content !!}
                    </div>                </div>                  
                
                <!-- Terms and Conditions -->
                <div id="terms" class="terms-section mb-5 py-5 px-4 bg-light rounded shadow-sm">
                    <div class="terms-header text-center">
                        <h3 class="fw-semibold mb-3">Terms and Conditions</h3>
                        <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
                    </div>
                    
                    <!-- Collapsed content by default -->
                    <div id="termsPreview" class="mb-4 text-center">
                        <p class="terms-preview">These terms and conditions apply to all rewards offered by The LaLiT Loyalty program.</p>
                    </div>
                    
                    <!-- Full content hidden by default -->
                    <div id="termsFullContent" class="mb-4 d-none">
                        <div class="terms-container">
                            <p class="text-center mb-4">Please review the following terms and conditions carefully:</p>
                            <ul class="terms-list">
                                <li>Rewards are subject to availability and may be changed or withdrawn at any time without notice.</li>
                                <li>Members must have sufficient points in their account at the time of redemption.</li>
                                <li>Points will be deducted from the member's account immediately upon redemption.</li>
                                <li>Once redeemed, rewards cannot be exchanged, returned, or refunded.</li>
                                <li>Rewards cannot be transferred to another member's account.</li>
                                <li>The LaLiT Loyalty program reserves the right to verify member identity before processing redemption requests.</li>
                                <li>Rewards have no cash value and cannot be sold or bartered.</li>
                                <li>Applicable taxes, if any, are the sole responsibility of the member.</li>
                                <li>Members must comply with all rules and regulations of The LaLiT Loyalty program.</li>
                                <li>The LaLiT Hotels and its affiliates are not responsible for any loss, injury, or damages arising from the redemption or use of rewards.</li>
                                <li>Additional terms and conditions may apply to specific rewards.</li>
                                <li>In case of any dispute, the decision of The LaLiT Hotels will be final and binding.</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Toggle button -->
                    <div class="text-center">
                        <button id="toggleTerms" class="btn btn-toggle-terms">
                            <span id="seeMoreText">See Complete Terms and Conditions</span>
                            <span id="seeLessText" class="d-none">Hide Terms and Conditions</span>
                            <i class="fas fa-chevron-down ms-2" id="chevronIcon"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>




@endsection

@push('styles')
<style>
    /* Custom styles for reward page */
    .reward-content {
        line-height: 1.8;
    }
    
    .reward-details img {
        max-width: 100%;
        height: auto;
        margin: 1.5rem 0;
    }
    
    .header-title-line {
        height: 3px;
        width: 5.875rem;
        background: #c6aa76;
        margin: 0 auto;
    }
    
    .btn-outline-gold {
        border: 2px solid #c6aa76;
        color: #c6aa76;
    }
    
    .btn-outline-gold:hover {
        background-color: #c6aa76;
        color: white;
    }
    
    .ct-btn {
        display: inline-block;
        text-decoration: none;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        border-radius: 0;
        transition: all 0.3s;
        background-color: #c6aa76;
        color: white;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.875rem;
    }
      .ct-btn:hover {
        background-color: #b09762;
        color: white;
        transform: translateY(-3px);
    }
      /* Terms and Conditions styles */
    .terms-section {
        transition: all 0.3s ease;
        position: relative;
        background-color: #f9f6f2 !important;
        border: 1px solid rgba(198, 170, 118, 0.2);
    }
    
    .terms-header h3 {
        font-family: 'Playfair Display', serif;
        color: #212322;
        letter-spacing: 1px;
    }
    
    .terms-preview {
        font-size: 1.1rem;
        color: #555;
        font-style: italic;
        max-width: 80%;
        margin: 0 auto;
    }
    
    .terms-container {
        max-width: 90%;
        margin: 0 auto;
        background-color: white;
        padding: 2rem;
        border-radius: 8px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }
    
    .terms-list {
        text-align: left;
        padding-left: 1.5rem;
        color: #444;
    }
    
    .terms-list li {
        margin-bottom: 0.75rem;
        line-height: 1.6;
        position: relative;
        padding-left: 0.5rem;
    }
    
    #toggleTerms {
        padding: 0.75rem 1.5rem;
        border: none;
        background: linear-gradient(to right, #c6aa76, #d4bc8d);
        color: white;
        border-radius: 30px;
        font-weight: 600;
        letter-spacing: 0.5px;
        box-shadow: 0 4px 10px rgba(198, 170, 118, 0.3);
        transition: all 0.3s ease;
    }
      #toggleTerms:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(198, 170, 118, 0.4);
        background: linear-gradient(to right, #b99c69, #c6aa76);
        color: white;    }
      /* Styles for other sections would go here */
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleButton = document.getElementById('toggleTerms');
    const termsPreview = document.getElementById('termsPreview');
    const termsFullContent = document.getElementById('termsFullContent');
    const seeMoreText = document.getElementById('seeMoreText');
    const seeLessText = document.getElementById('seeLessText');
    const chevronIcon = document.getElementById('chevronIcon');
    
    toggleButton.addEventListener('click', function() {
        termsPreview.classList.toggle('d-none');
        termsFullContent.classList.toggle('d-none');
        seeMoreText.classList.toggle('d-none');
        seeLessText.classList.toggle('d-none');
        
        // Rotate chevron icon
        if (chevronIcon) {
            if (termsFullContent.classList.contains('d-none')) {
                chevronIcon.classList.remove('fa-chevron-up');
                chevronIcon.classList.add('fa-chevron-down');
            } else {
                chevronIcon.classList.remove('fa-chevron-down');
                chevronIcon.classList.add('fa-chevron-up');
            }
        }
        
        // Smooth scroll to terms section if expanded
        if (!termsFullContent.classList.contains('d-none')) {
            setTimeout(() => {
                termsFullContent.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }, 100);
        }
    });
});
</script>
@endpush
