<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Members</h1>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <!-- Search and Filters -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('admin.members.index')); ?>" class="row g-3">
                            <div class="col-md-4">
                                <label for="search" class="form-label">Search</label>
                                <input type="text" class="form-control" id="search" name="search" 
                                       value="<?php echo e(request('search')); ?>" 
                                       placeholder="Name, email, member number, mobile...">
                            </div>
                            <div class="col-md-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="">All Statuses</option>
                                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                    <option value="suspended" <?php echo e(request('status') === 'suspended' ? 'selected' : ''); ?>>Suspended</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="tier" class="form-label">Tier</label>
                                <select class="form-select" id="tier" name="tier">
                                    <option value="">All Tiers</option>
                                    <?php $__currentLoopData = $tiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($tier): ?>
                                            <option value="<?php echo e($tier); ?>" <?php echo e(request('tier') === $tier ? 'selected' : ''); ?>>
                                                <?php echo e(ucfirst($tier)); ?>

                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                            </div>
                        </form>
                        <?php if(request()->hasAny(['search', 'status', 'tier'])): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(route('admin.members.index')); ?>" class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-times"></i> Clear Filters
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Members Count -->
                <div class="mb-3">
                    <p class="text-muted">
                        <strong>Total Members:</strong> <?php echo e($members->total()); ?>

                        <?php if(request()->hasAny(['search', 'status', 'tier'])): ?>
                            (filtered)
                        <?php endif; ?>
                    </p>
                </div>

                <?php if($members->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Member #</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Mobile</th>
                                    <th>Tier</th>
                                    <th>Status</th>
                                    <th>Joined</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <code><?php echo e($member->member_number ?? 'N/A'); ?></code>
                                    </td>
                                    <td>
                                        <strong><?php echo e($member->full_name); ?></strong>
                                        <?php if($member->email_verified): ?>
                                            <i class="fas fa-check-circle text-success ms-1" title="Email Verified"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small><?php echo e($member->email); ?></small>
                                    </td>
                                    <td>
                                        <small><?php echo e($member->mobile ?? 'N/A'); ?></small>
                                    </td>
                                    <td>
                                        <?php if($member->tier): ?>
                                            <span class="badge bg-info"><?php echo e(ucfirst($member->tier)); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($member->status === 'active'): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php elseif($member->status === 'inactive'): ?>
                                            <span class="badge bg-secondary">Inactive</span>
                                        <?php elseif($member->status === 'suspended'): ?>
                                            <span class="badge bg-danger">Suspended</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?php echo e(ucfirst($member->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small><?php echo e($member->created_at->format('M d, Y')); ?></small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.members.show', $member)); ?>" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.members.destroy', $member)); ?>" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('Are you sure you want to delete this member? This action cannot be undone.')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-danger" 
                                                        title="Delete Member">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($members->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5>No Members Found</h5>
                        <p class="text-muted">
                            <?php if(request()->hasAny(['search', 'status', 'tier'])): ?>
                                No members match your search criteria. Try adjusting your filters.
                            <?php else: ?>
                                There are no members registered yet.
                            <?php endif; ?>
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .table td {
        vertical-align: middle;
    }
    code {
        background-color: #f8f9fa;
        padding: 2px 6px;
        border-radius: 3px;
        color: #d63384;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/members/index.blade.php ENDPATH**/ ?>