<?php $__env->startSection('title', 'Set New Password - The Lalit Loyalty'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-6 col-lg-5">
      <div class="card shadow-lg border-0">
        <div class="card-body p-5">
          <!-- Header -->
          <div class="text-center mb-4">
            <div class="mb-3">
              <i class="fas fa-key fa-3x" style="color: #c6aa76;"></i>
            </div>
            <h2 class="fw-bold text-dark mb-2">Set New Password</h2>
            <p class="text-muted" id="pageDescription">Enter your email address to receive an OTP for password setup</p>
          </div>

          <!-- Alert Messages -->
          <div id="alertContainer" class="d-none mb-4">
            <div class="alert" role="alert" id="alertMessage"></div>
          </div>

          <!-- Step 1: Send OTP Form -->
          <form id="sendOtpForm">
            <?php echo csrf_field(); ?>
            <div id="emailStep">
              <!-- Email Field -->
              <div class="mb-4">
                <label for="email" class="form-label fw-semibold">
                  Email Address <span class="text-danger">*</span>
                </label>
                <div class="input-group">
                  <span class="input-group-text bg-light">
                    <i class="fas fa-envelope text-muted"></i>
                  </span>
                  <input 
                    type="email" 
                    class="form-control form-control-lg" 
                    id="email" 
                    name="email" 
                    placeholder="Enter your email address" 
                    required
                    value="<?php echo e(request()->get('email') ?? $email ?? ''); ?>"
                    <?php if(request()->get('email') || !empty($email)): ?> readonly <?php endif; ?>
                  >
                </div>
                <div class="invalid-feedback d-block" id="emailError"></div>
              </div>

              <!-- Send OTP Button -->
              <div class="d-grid mb-3">
                <button type="submit" class="btn btn-lg fw-semibold" id="sendResetPasswordOtpBtn" style="background-color: #c6aa76; border-color: #c6aa76; color: white;">
                  <span class="btn-text">
                    <i class="fas fa-paper-plane me-2"></i>Send OTP
                  </span>
                  <span class="btn-loading d-none">
                    <i class="fas fa-spinner fa-spin me-2"></i>Sending...
                  </span>
                </button>
              </div>

              <!-- Back to Login Link -->
              <div class="text-center">
                <a href="/member-login" class="text-decoration-none text-muted">
                  <i class="fas fa-arrow-left me-1"></i> Back to Login
                </a>
              </div>
            </div>
          </form>

          <!-- Step 2: Set Password Form -->
          <form id="setPasswordForm" class="d-none">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="passwordEmail" name="email">

            <!-- OTP Code Field -->
            <div class="mb-4">
              <label for="otp" class="form-label fw-semibold">
                OTP Code <span class="text-danger">*</span>
              </label>
              <div class="input-group">
                <span class="input-group-text bg-light">
                  <i class="fas fa-lock text-muted"></i>
                </span>
                <input 
                  type="text" 
                  class="form-control form-control-lg" 
                  id="otp" 
                  name="reset_key" 
                  placeholder="Enter OTP code" 
                  required
                  maxlength="6"
                >
              </div>
              <small class="text-muted">Enter the OTP code sent to your mobile</small>
              <div class="invalid-feedback d-block" id="otpError"></div>
            </div>

            <!-- New Password Field -->
            <div class="mb-4">
              <label for="newPassword" class="form-label fw-semibold">
                New Password <span class="text-danger">*</span>
              </label>
              <div class="input-group">
                <span class="input-group-text bg-light">
                  <i class="fas fa-key text-muted"></i>
                </span>
                <input 
                  type="password" 
                  class="form-control form-control-lg" 
                  id="newPassword" 
                  name="new_password" 
                  placeholder="Enter new password" 
                  required
                  minlength="8"
                >
                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                  <i class="fas fa-eye"></i>
                </button>
              </div>
              <small class="text-muted">Password must be at least 8 characters</small>
              <div class="invalid-feedback d-block" id="passwordError"></div>
            </div>

            <!-- Confirm Password Field -->
            <div class="mb-4">
              <label for="confirmPassword" class="form-label fw-semibold">
                Confirm Password <span class="text-danger">*</span>
              </label>
              <div class="input-group">
                <span class="input-group-text bg-light">
                  <i class="fas fa-key text-muted"></i>
                </span>
                <input 
                  type="password" 
                  class="form-control form-control-lg" 
                  id="confirmPassword" 
                  name="confirm_password" 
                  placeholder="Confirm new password" 
                  required
                  minlength="8"
                >
                <button class="btn btn-outline-secondary" type="button" id="toggleConfirmPassword">
                  <i class="fas fa-eye"></i>
                </button>
              </div>
              <div class="invalid-feedback d-block" id="confirmPasswordError"></div>
            </div>

            <!-- Set Password Button -->
            <div class="d-grid mb-3">
              <button type="submit" class="btn btn-lg fw-semibold" id="setPasswordBtn" style="background-color: #c6aa76; border-color: #c6aa76; color: white;">
                <span class="btn-text">
                  <i class="fas fa-check me-2"></i>Set Password
                </span>
                <span class="btn-loading d-none">
                  <i class="fas fa-spinner fa-spin me-2"></i>Setting Password...
                </span>
              </button>
            </div>

            <!-- Resend OTP Link -->
            <div class="text-center mb-3">
              <a href="#" id="resendOtpLink" class="text-decoration-none" style="color: #c6aa76;">
                <i class="fas fa-redo me-1"></i> Didn't receive the code? Resend OTP
              </a>
            </div>

            <!-- Back to Email Step -->
            <div class="text-center">
              <a href="#" id="backToEmailLink" class="text-decoration-none text-muted">
                <i class="fas fa-arrow-left me-1"></i> Change Email
              </a>
            </div>
          </form>

        </div>
      </div>

      <!-- Info Box -->
      <div class="card border-0 bg-light mt-4">
        <div class="card-body p-4">
          <h6 class="fw-bold mb-3">
            <i class="fas fa-info-circle me-2" style="color: #c6aa76;"></i>Password Requirements
          </h6>
          <ul class="mb-0 small text-muted">
            <li>Minimum 8 characters long</li>
            <li>Use a strong and unique password</li>
            <li>Keep your password secure and don't share it</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
  const sendOtpForm = document.getElementById('sendOtpForm');
  const setPasswordForm = document.getElementById('setPasswordForm');
  const emailStep = document.getElementById('emailStep');
  const sendResetPasswordOtpBtn = document.getElementById('sendResetPasswordOtpBtn');
  const setPasswordBtn = document.getElementById('setPasswordBtn');
  const emailInput = document.getElementById('email');
  const passwordEmailInput = document.getElementById('passwordEmail');
  const pageDescription = document.getElementById('pageDescription');
  const togglePassword = document.getElementById('togglePassword');
  const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
  const newPasswordInput = document.getElementById('newPassword');
  const confirmPasswordInput = document.getElementById('confirmPassword');

  // Toggle password visibility
  togglePassword.addEventListener('click', function() {
    const type = newPasswordInput.type === 'password' ? 'text' : 'password';
    newPasswordInput.type = type;
    this.querySelector('i').classList.toggle('fa-eye');
    this.querySelector('i').classList.toggle('fa-eye-slash');
  });

  toggleConfirmPassword.addEventListener('click', function() {
    const type = confirmPasswordInput.type === 'password' ? 'text' : 'password';
    confirmPasswordInput.type = type;
    this.querySelector('i').classList.toggle('fa-eye');
    this.querySelector('i').classList.toggle('fa-eye-slash');
  });

  // Send OTP Form Submission
  sendOtpForm.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    clearErrors();
    hideAlert();
    
    const email = emailInput.value;
    
    // Show loading state
    sendResetPasswordOtpBtn.disabled = true;
    sendResetPasswordOtpBtn.querySelector('.btn-text').classList.add('d-none');
    sendResetPasswordOtpBtn.querySelector('.btn-loading').classList.remove('d-none');
    
    try {
      const response = await fetch('/membership/send-reset-otp', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json'
        },
        body: JSON.stringify({ email: email })
      });
      
      const data = await response.json();
      
      if (data.success || data.status === 'success') {
        showAlert('success', data.message || 'OTP sent successfully to your mobile!');
        
        // Switch to password form
        setTimeout(() => {
          emailStep.classList.add('d-none');
          setPasswordForm.classList.remove('d-none');
          passwordEmailInput.value = email;
          pageDescription.textContent = 'Enter the OTP and set your new password';
          document.getElementById('otp').focus();
        }, 1000);
      } else {
        showAlert('danger', data.message || 'Failed to send OTP. Please try again.');
        if (data.errors && data.errors.email) {
          document.getElementById('emailError').textContent = data.errors.email[0];
        }
      }
    } catch (error) {
      console.error('Error:', error);
      showAlert('danger', 'An error occurred. Please try again.');
    } finally {
      sendResetPasswordOtpBtn.disabled = false;
      sendResetPasswordOtpBtn.querySelector('.btn-text').classList.remove('d-none');
      sendResetPasswordOtpBtn.querySelector('.btn-loading').classList.add('d-none');
    }
  });

  // Set Password Form Submission
  setPasswordForm.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    clearErrors();
    hideAlert();
    
    const formData = new FormData(setPasswordForm);
    const data = Object.fromEntries(formData);
    
    // Validate password match
    if (data.new_password !== data.confirm_password) {
      document.getElementById('confirmPasswordError').textContent = 'Passwords do not match';
      return;
    }
    
    // Show loading state
    setPasswordBtn.disabled = true;
    setPasswordBtn.querySelector('.btn-text').classList.add('d-none');
    setPasswordBtn.querySelector('.btn-loading').classList.remove('d-none');
    
    try {
      const response = await fetch('/membership/reset-password', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json'
        },
        body: JSON.stringify(data)
      });
      
      const result = await response.json();
      
      if (result.success || result.status === 'success') {
        showAlert('success', result.message || 'Password set successfully! Redirecting to dashboard...');
        
        // Redirect to dashboard after 2 seconds
        setTimeout(() => {
          window.location.href = result.redirect || '/membership/dashboard';
        }, 2000);
      } else {
        showAlert('danger', result.message || 'Failed to set password. Please check your OTP and try again.');
        
        if (result.errors) {
          if (result.errors.reset_key) {
            document.getElementById('otpError').textContent = Array.isArray(result.errors.reset_key) ? result.errors.reset_key[0] : result.errors.reset_key;
          }
          if (result.errors.new_password) {
            document.getElementById('passwordError').textContent = Array.isArray(result.errors.new_password) ? result.errors.new_password[0] : result.errors.new_password;
          }
        }
      }
    } catch (error) {
      console.error('Error:', error);
      showAlert('danger', 'An error occurred. Please try again.');
    } finally {
      setPasswordBtn.disabled = false;
      setPasswordBtn.querySelector('.btn-text').classList.remove('d-none');
      setPasswordBtn.querySelector('.btn-loading').classList.add('d-none');
    }
  });

  // Resend OTP
  document.getElementById('resendOtpLink').addEventListener('click', async function(e) {
    e.preventDefault();
    
    const email = passwordEmailInput.value;
    
    try {
      const response = await fetch('/membership/send-reset-otp', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json'
        },
        body: JSON.stringify({ email: email })
      });
      
      const data = await response.json();
      
      if (data.success || data.status === 'success') {
        showAlert('success', 'OTP resent successfully!');
      } else {
        showAlert('danger', data.message || 'Failed to resend OTP.');
      }
    } catch (error) {
      showAlert('danger', 'An error occurred. Please try again.');
    }
  });

  // Back to Email Step
  document.getElementById('backToEmailLink').addEventListener('click', function(e) {
    e.preventDefault();
    
    setPasswordForm.classList.add('d-none');
    setPasswordForm.reset();
    emailStep.classList.remove('d-none');
    pageDescription.textContent = 'Enter your email address to receive an OTP for password setup';
    clearErrors();
    hideAlert();
  });

  // Helper Functions
  function showAlert(type, message) {
    const alertContainer = document.getElementById('alertContainer');
    const alertMessage = document.getElementById('alertMessage');
    
    alertContainer.classList.remove('d-none');
    alertMessage.className = `alert alert-${type}`;
    alertMessage.innerHTML = `<i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>${message}`;
    
    // Scroll to alert
    alertContainer.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
  }

  function hideAlert() {
    document.getElementById('alertContainer').classList.add('d-none');
  }

  function clearErrors() {
    document.querySelectorAll('.invalid-feedback').forEach(el => el.textContent = '');
  }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/membership/set-new-password.blade.php ENDPATH**/ ?>