<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Artisan Commands</h1>
                    <div class="badge bg-info">System Management</div>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('output')): ?>
                    <div class="alert alert-info" role="alert">
                        <h6><i class="fas fa-terminal"></i> Command Output:</h6>
                        <pre class="mb-0" style="white-space: pre-wrap; font-size: 0.9em;"><?php echo e(session('output')); ?></pre>
                    </div>
                <?php endif; ?>

                <div class="row g-4">
                    <!-- Cache Management -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-memory"></i> Cache Management
                                </h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text text-muted">
                                    Clear various types of application cache to ensure fresh data and configurations.
                                </p>
                                <div class="d-grid gap-2">
                                    <form action="<?php echo e(route('admin.artisan.clear-cache')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-danger w-100">
                                            <i class="fas fa-trash"></i> Clear Application Cache
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.artisan.clear-config')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-warning w-100">
                                            <i class="fas fa-cog"></i> Clear Config Cache
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.artisan.clear-route')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-info w-100">
                                            <i class="fas fa-route"></i> Clear Route Cache
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.artisan.clear-view')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-secondary w-100">
                                            <i class="fas fa-eye"></i> Clear View Cache
                                        </button>
                                    </form>
                                    <hr>
                                    <form action="<?php echo e(route('admin.artisan.clear-all')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-danger w-100" onclick="return confirm('This will clear all cache types. Continue?')">
                                            <i class="fas fa-bomb"></i> Clear All Caches
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Optimization -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-success text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-rocket"></i> Optimization
                                </h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text text-muted">
                                    Cache configurations and routes for better performance in production.
                                </p>
                                <div class="d-grid gap-2">
                                    <form action="<?php echo e(route('admin.artisan.cache-config')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-success w-100">
                                            <i class="fas fa-cog"></i> Cache Config
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.artisan.cache-route')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-success w-100">
                                            <i class="fas fa-route"></i> Cache Routes
                                        </button>
                                    </form>
                                    <hr>
                                    <form action="<?php echo e(route('admin.artisan.optimize')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success w-100">
                                            <i class="fas fa-rocket"></i> Optimize Application
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Storage & Files -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-warning text-dark">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-folder"></i> Storage & Files
                                </h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text text-muted">
                                    Manage storage symlinks for file uploads and public access.
                                </p>
                                <div class="d-grid gap-2">
                                    <form action="<?php echo e(route('admin.artisan.storage-link')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-warning w-100">
                                            <i class="fas fa-link"></i> Create Storage Link
                                        </button>
                                    </form>
                                </div>
                                <small class="text-muted mt-2 d-block">
                                    <i class="fas fa-info-circle"></i> Creates symbolic link from public/storage to storage/app/public
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Database -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-info text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-database"></i> Database
                                </h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text text-muted">
                                    Run database migrations and manage database schema.
                                </p>
                                <div class="d-grid gap-2">
                                    <form action="<?php echo e(route('admin.artisan.migrate')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-outline-info w-100" onclick="return confirm('This will run database migrations. Continue?')">
                                            <i class="fas fa-play"></i> Run Migrations
                                        </button>
                                    </form>
                                </div>
                                <small class="text-muted mt-2 d-block">
                                    <i class="fas fa-exclamation-triangle"></i> Use with caution in production
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-bolt"></i> Quick Actions
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-light border" role="alert">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-1">Development Mode Actions</h6>
                                            <small class="text-muted">Common commands for development and debugging</small>
                                        </div>
                                        <div class="btn-group" role="group">
                                            <form action="<?php echo e(route('admin.artisan.clear-all')); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-broom"></i> Clear All
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('admin.artisan.storage-link')); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-warning">
                                                    <i class="fas fa-link"></i> Storage Link
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Warning Notice -->
                <div class="alert alert-warning mt-4" role="alert">
                    <h6><i class="fas fa-exclamation-triangle"></i> Important Notice</h6>
                    <small>
                        These commands directly affect your application's performance and functionality. 
                        Use with caution, especially in production environments. Always backup your data before running database migrations.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/artisan/index.blade.php ENDPATH**/ ?>