<div class="row mb-3">
    <div class="col-md-8">
        <!-- Basic Information -->
        <div class="card mb-3">
            <div class="card-header">Basic Information</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title', $page->title ?? '')); ?>" required>
                </div>

                <div class="mb-3">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo e(old('slug', $page->slug ?? '')); ?>">
                    <div class="form-text">Leave empty to auto-generate from title</div>
                </div>

                <div class="mb-3">
                    <label for="excerpt" class="form-label">Excerpt</label>
                    <textarea class="form-control" id="excerpt" name="excerpt" rows="3"><?php echo e(old('excerpt', $page->excerpt ?? '')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label for="content" class="form-label">Content <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="content" name="content" rows="10" required><?php echo e(old('content', $page->content ?? '')); ?></textarea>
                </div>
            </div>
        </div>

        <!-- SEO Section -->
        <div class="card mb-3">
            <div class="card-header">SEO Information</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="seo_title" class="form-label">SEO Title</label>
                    <input type="text" class="form-control" id="seo_title" name="seo_title" value="<?php echo e(old('seo_title', $page->seo_title ?? '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="seo_description" class="form-label">SEO Description</label>
                    <textarea class="form-control" id="seo_description" name="seo_description" rows="3"><?php echo e(old('seo_description', $page->seo_description ?? '')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label for="meta_keywords" class="form-label">Meta Keywords</label>
                    <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo e(old('meta_keywords', $page->meta_keywords ?? '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="meta_robots" class="form-label">Meta Robots</label>
                    <input type="text" class="form-control" id="meta_robots" name="meta_robots" value="<?php echo e(old('meta_robots', $page->meta_robots ?? '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="canonical_url" class="form-label">Canonical URL</label>
                    <input type="text" class="form-control" id="canonical_url" name="canonical_url" value="<?php echo e(old('canonical_url', $page->canonical_url ?? '')); ?>">
                </div>
            </div>
        </div>

        <!-- Open Graph Section -->
        <div class="card mb-3">
            <div class="card-header">Open Graph Data</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="og_title" class="form-label">OG Title</label>
                    <input type="text" class="form-control" id="og_title" name="og_data[title]" 
                        value="<?php echo e(old('og_data.title', isset($page) && isset($page->og_data['title']) ? $page->og_data['title'] : '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="og_description" class="form-label">OG Description</label>
                    <textarea class="form-control" id="og_description" name="og_data[description]" rows="2"><?php echo e(old('og_data.description', isset($page) && isset($page->og_data['description']) ? $page->og_data['description'] : '')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label for="og_type" class="form-label">OG Type</label>
                    <select class="form-select" id="og_type" name="og_data[type]">
                        <option value="">Select OG Type</option>
                        <option value="website" <?php echo e((old('og_data.type', isset($page) && isset($page->og_data['type']) ? $page->og_data['type'] : '') === 'website') ? 'selected' : ''); ?>>Website</option>
                        <option value="article" <?php echo e((old('og_data.type', isset($page) && isset($page->og_data['type']) ? $page->og_data['type'] : '') === 'article') ? 'selected' : ''); ?>>Article</option>
                        <option value="product" <?php echo e((old('og_data.type', isset($page) && isset($page->og_data['type']) ? $page->og_data['type'] : '') === 'product') ? 'selected' : ''); ?>>Product</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="og_image" class="form-label">OG Image URL</label>
                    <input type="text" class="form-control" id="og_image" name="og_data[image]" 
                        value="<?php echo e(old('og_data.image', isset($page) && isset($page->og_data['image']) ? $page->og_data['image'] : '')); ?>">
                </div>
            </div>
        </div>

        <!-- Twitter Card Section -->
        <div class="card mb-3">
            <div class="card-header">Twitter Card Data</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="twitter_card" class="form-label">Twitter Card Type</label>
                    <select class="form-select" id="twitter_card" name="twitter_data[card]">
                        <option value="">Select Card Type</option>
                        <option value="summary" <?php echo e((old('twitter_data.card', isset($page) && isset($page->twitter_data['card']) ? $page->twitter_data['card'] : '') === 'summary') ? 'selected' : ''); ?>>Summary</option>
                        <option value="summary_large_image" <?php echo e((old('twitter_data.card', isset($page) && isset($page->twitter_data['card']) ? $page->twitter_data['card'] : '') === 'summary_large_image') ? 'selected' : ''); ?>>Summary Large Image</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="twitter_title" class="form-label">Twitter Title</label>
                    <input type="text" class="form-control" id="twitter_title" name="twitter_data[title]" 
                        value="<?php echo e(old('twitter_data.title', isset($page) && isset($page->twitter_data['title']) ? $page->twitter_data['title'] : '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="twitter_description" class="form-label">Twitter Description</label>
                    <textarea class="form-control" id="twitter_description" name="twitter_data[description]" rows="2"><?php echo e(old('twitter_data.description', isset($page) && isset($page->twitter_data['description']) ? $page->twitter_data['description'] : '')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label for="twitter_image" class="form-label">Twitter Image URL</label>
                    <input type="text" class="form-control" id="twitter_image" name="twitter_data[image]" 
                        value="<?php echo e(old('twitter_data.image', isset($page) && isset($page->twitter_data['image']) ? $page->twitter_data['image'] : '')); ?>">
                </div>
            </div>
        </div>

        <!-- Schema Markup Section -->
        <div class="card mb-3">
            <div class="card-header">Schema Markup</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="schema_markup" class="form-label">JSON-LD Markup</label>
                    <textarea class="form-control" id="schema_markup" name="schema_markup" rows="6"><?php echo e(old('schema_markup', $page->schema_markup ?? '')); ?></textarea>
                    <div class="form-text">Enter valid JSON-LD schema markup</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <!-- Publishing Options -->
        <div class="card mb-3">
            <div class="card-header">Publishing Options</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="draft" <?php echo e(old('status', $page->status ?? '') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                        <option value="published" <?php echo e(old('status', $page->status ?? '') == 'published' ? 'selected' : ''); ?>>Published</option>
                        <option value="private" <?php echo e(old('status', $page->status ?? '') == 'private' ? 'selected' : ''); ?>>Private</option>
                        <option value="archived" <?php echo e(old('status', $page->status ?? '') == 'archived' ? 'selected' : ''); ?>>Archived</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="published_at" class="form-label">Publish Date</label>
                    <input type="datetime-local" class="form-control" id="published_at" name="published_at"
                        value="<?php echo e(old('published_at', isset($page) && $page->published_at ? $page->published_at->format('Y-m-d\TH:i') : '')); ?>">
                </div>

                <div class="mb-3">
                    <label for="sort_order" class="form-label">Sort Order</label>
                    <input type="number" class="form-control" id="sort_order" name="sort_order" value="<?php echo e(old('sort_order', $page->sort_order ?? 0)); ?>">
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured" value="1" 
                        <?php echo e(old('is_featured', $page->is_featured ?? false) ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="is_featured">Featured Page</label>
                </div>
            </div>
        </div>

        <!-- Media Options -->
        <div class="card mb-3">
            <div class="card-header">Featured Image</div>
            <div class="card-body">
                <?php if(isset($page) && $page->featured_image): ?>
                    <div class="mb-3">
                        <label class="form-label">Current Image</label>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $page->featured_image)); ?>" class="img-thumbnail d-block" style="max-height: 150px;">
                        </div>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label for="featured_image" class="form-label"><?php echo e(isset($page) && $page->featured_image ? 'Change' : 'Add'); ?> Featured Image</label>
                    <input type="file" class="form-control" id="featured_image" name="featured_image">
                </div>

                <div class="mb-3">
                    <label for="featured_image_alt" class="form-label">Image Alt Text</label>
                    <input type="text" class="form-control" id="featured_image_alt" name="featured_image_alt" 
                        value="<?php echo e(old('featured_image_alt', $page->featured_image_alt ?? '')); ?>">
                </div>
            </div>
        </div>

        <!-- Banner Image -->
        <div class="card mb-3">
            <div class="card-header">Banner Image</div>
            <div class="card-body">
                <?php if(isset($page) && $page->banner_image): ?>
                    <div class="mb-3">
                        <label class="form-label">Current Banner</label>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $page->banner_image)); ?>" class="img-thumbnail d-block" style="max-height: 150px;">
                        </div>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label for="banner_image" class="form-label"><?php echo e(isset($page) && $page->banner_image ? 'Change' : 'Add'); ?> Banner Image</label>
                    <input type="file" class="form-control" id="banner_image" name="banner_image">
                </div>

                <div class="mb-3">
                    <label for="banner_image_alt" class="form-label">Banner Alt Text</label>
                    <input type="text" class="form-control" id="banner_image_alt" name="banner_image_alt" 
                        value="<?php echo e(old('banner_image_alt', $page->banner_image_alt ?? '')); ?>">
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/pages/form.blade.php ENDPATH**/ ?>