<?php $__env->startSection('title', 'Donations'); ?>

<?php $__env->startSection('content'); ?>
  <div class="container-fluid py-4">
    <div class="row">
      <div class="col-12">
        <div class="card">
          <div class="card-header pb-0">
            <div class="d-lg-flex">
              <div>
                <h5 class="mb-0">Donations Management</h5>
                <p class="text-sm mb-0">
                  Manage donation campaigns and fundraising initiatives.
                </p>
              </div>
              <div class="ms-auto my-auto mt-lg-0 mt-4">
                <div class="ms-auto my-auto">
                  <a href="<?php echo e(route('admin.donations.create')); ?>" class="btn bg-gradient-primary btn-sm mb-0">
                    +&nbsp; New Donation
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="card-body px-0 pb-0">
            <?php if(session('success')): ?>
              <div class="alert alert-success mx-4">
                <?php echo e(session('success')); ?>

              </div>
            <?php endif; ?>

            <?php if($donations->count() > 0): ?>
              <div class="table-responsive">
                <table class="table table-flush" id="donations-table">
                  <thead class="thead-light">
                    <tr>
                      <th>Image</th>
                      <th>Title</th>
                      <th>Donate Points</th>
                      <th>INR Value</th>
                      <th>Status</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td>
                          <?php if($donation->image): ?>
                            <img src="<?php echo e(Storage::url($donation->image)); ?>" alt="Donation Image" class="img-thumbnail"
                              style="width: 50px; height: 50px; object-fit: cover;">
                          <?php else: ?>
                            <div class="bg-light d-flex align-items-center justify-content-center"
                              style="width: 50px; height: 50px;">
                              <i class="fas fa-image text-muted"></i>
                            </div>
                          <?php endif; ?>
                        </td>
                        <td>
                          <h6 class="mb-0 text-sm"><?php echo e($donation->title); ?></h6>
                          <?php if($donation->description): ?>
                            <small class="text-muted"><?php echo e(Str::limit($donation->description, 50)); ?></small>
                          <?php endif; ?>
                        </td>
                        <td>
                          <span class="fw-bold text-warning"><?php echo e($donation->donate_points); ?></span>
                        </td>
                        <td><?php echo e($donation->formatted_inr_value); ?></td>
                        <td>
                          <?php if($donation->is_active): ?>
                            <span class="badge badge-sm bg-gradient-success">Active</span>
                          <?php else: ?>
                            <span class="badge badge-sm bg-gradient-secondary">Inactive</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <div class="dropdown">
                            <button class="btn btn-link text-secondary mb-0" data-bs-toggle="dropdown" aria-expanded="false">
                              <i class="fa fa-ellipsis-v text-xs"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                              <a class="dropdown-item" href="<?php echo e(route('admin.donations.show', $donation)); ?>">
                                <i class="fas fa-eye me-2"></i> View
                              </a>
                              <a class="dropdown-item" href="<?php echo e(route('admin.donations.edit', $donation)); ?>">
                                <i class="fas fa-edit me-2"></i> Edit
                              </a>
                              <div class="dropdown-divider"></div>
                              <form action="<?php echo e(route('admin.donations.destroy', $donation)); ?>" method="POST"
                                onsubmit="return confirm('Are you sure you want to delete this donation?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="dropdown-item text-danger">
                                  <i class="fas fa-trash me-2"></i> Delete
                                </button>
                              </form>
                            </div>
                          </div>
                        </td>
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
              </div>

            <?php else: ?>
              <div class="text-center py-5">
                <i class="fas fa-heart fa-3x text-muted mb-3"></i>
                <h5>No Donations Yet</h5>
                <p class="text-muted">Start by creating your first donation campaign.</p>
                <a href="<?php echo e(route('admin.donations.create')); ?>" class="btn bg-gradient-primary">
                  Create First Donation
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script>
    // Add any JavaScript functionality here if needed
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/donations/index.blade.php ENDPATH**/ ?>