<?php



class View

{

    protected $set_val = [];

    protected $show_bread_crumb =  [];

    protected $js_array = [];

    protected $css_array = [];

    public function __construct()

    {

    }



    public function setVal($key, $val)

    {

        $this->set_val[$key] = $val;

    }



    public function setBreadCrumb($key, $val)

    {

        $this->show_bread_crumb[$key] = $val;

    }



    public function render($viewScript)

    {

        extract($this->set_val);

        require_once $viewScript.'.php';

    }





    public function loadCss($css)

    {

        foreach ($css as $cv) {

            $this->css_array[] = '<link href="' . CSS_ADMIN_ASSETS_DIR . $cv . '" rel="stylesheet" type="text/css"/>';

        }

    }



    public function loadPlugins($arr, $mode)

    {

        if ($mode == true) {

            foreach ($arr as $jv) {

                $this->js_array[] = '<script src="' . PLUGINS_ADMIN_ASSETS_DIR . $jv . '"></script>';

            }

        } else {

            foreach ($arr as $cv) {

                $this->css_array[] = '<link href="' . PLUGINS_ADMIN_ASSETS_DIR . $cv . '" rel="stylesheet" type="text/css"/>';

            }

        }

    }



    public function loadJs($js)

    {

        foreach ($js as $jv) {

            $this->js_array[] = '<script src="' . JS_ADMIN_ASSETS_DIR . $jv . '"></script>';

        }

    }



    public function renderFront($viewScript)

    {

        if (count($this->show_bread_crumb) > 0) {

            $this->setVal('bread_crumb', $this->show_bread_crumb);

        }



        $this->setVal('css_array', $this->css_array);

        $this->setVal('js_array', $this->js_array);

        extract($this->set_val);

        require_once VIEW_DIR . 'master/header.php';

        require_once $viewScript . '.php';

        require_once VIEW_DIR . 'master/footer.php';

    }

    

    public function renderAdmin($viewScript)

    {

        if (count($this->show_bread_crumb) > 0) {

            $this->setVal('bread_crumb', $this->show_bread_crumb);

        }



        $this->setVal('css_array', $this->css_array);

        $this->setVal('js_array', $this->js_array);

        extract($this->set_val);

        require_once VIEW_DIR . 'master/admin/header.php';

        require_once VIEW_DIR . 'admin/'.$viewScript . '.php';

        require_once VIEW_DIR . 'master/admin/footer.php';

    }

}

