<?php

$routes = [
    '/' => ['controller_path' => 'HomeController', 'controller' => 'HomeController', 'method' => 'index'],
    '/users' => ['controller_path' => 'HomeController', 'controller' => 'UserController', 'method' => 'index'],
    '/users/create', ['controller_path' => 'HomeController', 'controller' => 'UserController', 'method' => 'create'],
    '/users/edit' => ['controller_path' => 'HomeController', 'controller' => 'UserController', 'method' => 'edit'],
    '/users/delete' => ['controller_path' => 'HomeController', 'controller' => 'UserController', 'method' => 'delete']
];

class Route
{
    public function __construct()
    {
        $this->getRoute();
    }

    public static function getRoute()
    {

        global $route_url;
        global $routes;
        $uri =  $route_url;
        if (!in_array($uri, $routes)) {
            return redirect('page-not-found');
        }
        return $uri;
    }

    public static function run()
    {
        try {
            return self::getRoute();
        } catch (Exception $e) {
            return redirect('page-not-found');
        }
    }
}
