# Laravel Web Project

A Laravel web application with modern frontend tooling.

## 🚀 Getting Started

Follow these steps to set up and run the project locally:

### Prerequisites

- PHP >= 8.1
- Composer
- Node.js & npm
- MySQL/PostgreSQL (or your preferred database)

### Installation

1. **Clone the repository** (if not already done)
   ```bash
   git clone <repository-url>
   cd laravel-web
   ```

2. **Create environment file**
   ```bash
   cp .env.example .env
   ```
   Update your database credentials in the `.env` file:
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=your_database_name
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

3. **Install PHP dependencies**
   ```bash
   composer install
   ```

4. **Install Node.js dependencies**
   ```bash
   npm install
   ```

5. **Build frontend assets**
   ```bash
   npm run build
   ```

6. **Generate application key**
   ```bash
   php artisan key:generate
   ```

7. **Run database migrations**
   ```bash
   php artisan migrate
   ```

8. **Start the development server**
   ```bash
   composer run dev
   ```
   
   Your application will be available at `http://localhost:8000`

## 🛠️ Development

For development with hot reloading of frontend assets:

```bash
# Terminal 1 - Laravel development server
php artisan serve

# Terminal 2 - Vite development server for assets
npm run dev
```

## 📝 Additional Commands

- **Run tests**: `php artisan test`
- **Clear cache**: `php artisan cache:clear`
- **Clear config**: `php artisan config:clear`
- **Fresh migration**: `php artisan migrate:fresh --seed`

## 🤝 Contributing

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## 📄 License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).

