<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('points', function (Blueprint $table) {
            // Hotel Stays fields
            $table->string('hotel_stays_icon')->nullable()->default('fas fa-hotel')->after('hotel_stays_content');
            $table->string('hotel_stays_title')->nullable()->default('Hotel Stays')->after('hotel_stays_icon');
            
            // Dining fields
            $table->string('dining_icon')->nullable()->default('fas fa-utensils')->after('dining_content');
            $table->string('dining_title')->nullable()->default('Dining')->after('dining_icon');
            
            // Spa fields
            $table->string('spa_icon')->nullable()->default('fas fa-spa')->after('spa_content');
            $table->string('spa_title')->nullable()->default('Spa')->after('spa_icon');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn([
                'hotel_stays_icon', 
                'hotel_stays_title',
                'dining_icon', 
                'dining_title',
                'spa_icon', 
                'spa_title'
            ]);
        });
    }
};
