<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('package_details', function (Blueprint $table) {
            $table->string('membership_benefits_title')->nullable()->default('About Membership Benefits');
            $table->text('membership_benefits_content')->nullable();
            $table->text('membership_benefits_disclaimer')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('package_details', function (Blueprint $table) {
            $table->dropColumn('membership_benefits_title');
            $table->dropColumn('membership_benefits_content');
            $table->dropColumn('membership_benefits_disclaimer');
        });
    }
};
