@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Edit Benefit</h1>
                    <div>
                        <a href="{{ route('admin.benefits.show', $benefit) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                        <a href="{{ route('admin.benefits.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Benefits
                        </a>
                    </div>
                </div>

                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.benefits.update', $benefit) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row mb-3">
                        <div class="col-md-8">
                            <div class="card mb-3">
                                <div class="card-header">Basic Information</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $benefit->title) }}" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="slug" class="form-label">Slug</label>
                                        <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug', $benefit->slug) }}">
                                        <div class="form-text">Leave empty to auto-generate from title</div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="excerpt" class="form-label">Excerpt</label>
                                        <textarea class="form-control" id="excerpt" name="excerpt" rows="3">{{ old('excerpt', $benefit->excerpt) }}</textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="custom_link" class="form-label">Custom Link</label>
                                        <input type="url" class="form-control" id="custom_link" name="custom_link" value="{{ old('custom_link', $benefit->custom_link) }}" placeholder="https://example.com">
                                        <div class="form-text">Optional custom link for this benefit (e.g., to an external page or special offer)</div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="content" class="form-label">Content</label>
                                        <textarea class="form-control" id="content" name="content" rows="10">{{ old('content', $benefit->content) }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- SEO Section -->
                            <div class="card mb-3">
                                <div class="card-header">SEO Information</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="meta_title" class="form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ old('meta_title', $benefit->meta_title) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_description" class="form-label">Meta Description</label>
                                        <textarea class="form-control" id="meta_description" name="meta_description" rows="3">{{ old('meta_description', $benefit->meta_description) }}</textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                        <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $benefit->meta_keywords) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="meta_robots" class="form-label">Meta Robots</label>
                                        <input type="text" class="form-control" id="meta_robots" name="meta_robots" value="{{ old('meta_robots', $benefit->meta_robots) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="canonical_url" class="form-label">Canonical URL</label>
                                        <input type="text" class="form-control" id="canonical_url" name="canonical_url" value="{{ old('canonical_url', $benefit->canonical_url) }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Publishing Options -->
                            <div class="card mb-3">
                                <div class="card-header">Publishing Options</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                        <select class="form-select" id="status" name="status">
                                            <option value="draft" {{ old('status', $benefit->status) == 'draft' ? 'selected' : '' }}>Draft</option>
                                            <option value="published" {{ old('status', $benefit->status) == 'published' ? 'selected' : '' }}>Published</option>
                                            <option value="archived" {{ old('status', $benefit->status) == 'archived' ? 'selected' : '' }}>Archived</option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="published_at" class="form-label">Publish Date</label>
                                        <input type="datetime-local" class="form-control" id="published_at" name="published_at" 
                                               value="{{ old('published_at', $benefit->published_at ? $benefit->published_at->format('Y-m-d\TH:i') : '') }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="sort_order" class="form-label">Sort Order</label>
                                        <input type="number" class="form-control" id="sort_order" name="sort_order" value="{{ old('sort_order', $benefit->sort_order) }}">
                                    </div>

                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured" value="1" 
                                               {{ old('is_featured', $benefit->is_featured) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_featured">Featured Benefit</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Current Featured Image -->
                            @if($benefit->featured_image)
                            <div class="card mb-3">
                                <div class="card-header">Current Featured Image</div>
                                <div class="card-body">
                                    <img src="{{ Storage::url($benefit->featured_image) }}" class="img-fluid mb-2" alt="{{ $benefit->featured_image_alt }}" style="max-height: 200px;">
                                    <p class="text-muted small">{{ $benefit->featured_image_alt }}</p>
                                </div>
                            </div>
                            @endif

                            <!-- Media Options -->
                            <div class="card mb-3">
                                <div class="card-header">Featured Image</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="featured_image" class="form-label">{{ $benefit->featured_image ? 'Replace' : 'Upload' }} Featured Image</label>
                                        <input type="file" class="form-control" id="featured_image" name="featured_image" accept="image/*">
                                    </div>

                                    <div class="mb-3">
                                        <label for="featured_image_alt" class="form-label">Image Alt Text</label>
                                        <input type="text" class="form-control" id="featured_image_alt" name="featured_image_alt" 
                                               value="{{ old('featured_image_alt', $benefit->featured_image_alt) }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="featured_image_caption" class="form-label">Image Caption</label>
                                        <input type="text" class="form-control" id="featured_image_caption" name="featured_image_caption" 
                                               value="{{ old('featured_image_caption', $benefit->featured_image_caption) }}">
                                    </div>
                                </div>
                            </div>

                            <!-- Current Banner Image -->
                            @if($benefit->banner_image)
                            <div class="card mb-3">
                                <div class="card-header">Current Banner Image</div>
                                <div class="card-body">
                                    <img src="{{ Storage::url($benefit->banner_image) }}" class="img-fluid mb-2" alt="{{ $benefit->banner_image_alt }}" style="max-height: 200px;">
                                    <p class="text-muted small">{{ $benefit->banner_image_alt }}</p>
                                </div>
                            </div>
                            @endif

                            <!-- Banner Image -->
                            <div class="card mb-3">
                                <div class="card-header">Banner Image</div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="banner_image" class="form-label">{{ $benefit->banner_image ? 'Replace' : 'Upload' }} Banner Image</label>
                                        <input type="file" class="form-control" id="banner_image" name="banner_image" accept="image/*">
                                    </div>

                                    <div class="mb-3">
                                        <label for="banner_image_alt" class="form-label">Banner Alt Text</label>
                                        <input type="text" class="form-control" id="banner_image_alt" name="banner_image_alt" 
                                               value="{{ old('banner_image_alt', $benefit->banner_image_alt) }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Update Benefit</button>
                        <a href="{{ route('admin.benefits.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-generate slug from title (only if slug is empty)
        const titleInput = document.getElementById('title');
        const slugInput = document.getElementById('slug');
        
        if (titleInput && slugInput) {
            titleInput.addEventListener('keyup', function() {
                if (!slugInput.value) {
                    slugInput.value = titleInput.value
                        .toLowerCase()
                        .replace(/[^a-z0-9\s-]/g, '')
                        .replace(/[\s-]+/g, '-')
                        .replace(/^-+|-+$/g, '');
                }
            });
        }
    });
</script>
@endpush
