@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Benefit: {{ $benefit->title }}</h1>
                    <div>
                        <a href="{{ route('admin.benefits.edit', $benefit) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.benefits.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Benefits
                        </a>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="row mb-4">
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span>Benefit Details</span>
                                <span class="badge {{ $benefit->status == 'published' ? 'bg-success' : ($benefit->status == 'draft' ? 'bg-warning' : 'bg-secondary') }}">
                                    {{ ucfirst($benefit->status) }}
                                </span>
                            </div>
                            <div class="card-body">
                                @if($benefit->featured_image || $benefit->banner_image)
                                <div class="row mb-4">
                                    @if($benefit->featured_image)
                                    <div class="col-md-6 mb-3">
                                        <h5>Featured Image</h5>
                                        <img src="{{ Storage::url($benefit->featured_image) }}" class="img-fluid rounded" 
                                            alt="{{ $benefit->featured_image_alt }}">
                                        @if($benefit->featured_image_caption)
                                        <p class="mt-2 text-muted">{{ $benefit->featured_image_caption }}</p>
                                        @endif
                                    </div>
                                    @endif
                                    
                                    @if($benefit->banner_image)
                                    <div class="col-md-6 mb-3">
                                        <h5>Banner Image</h5>
                                        <img src="{{ Storage::url($benefit->banner_image) }}" class="img-fluid rounded" 
                                            alt="{{ $benefit->banner_image_alt }}">
                                    </div>
                                    @endif
                                </div>
                                <hr>
                                @endif

                                <h2>{{ $benefit->title }}</h2>
                                
                                @if($benefit->custom_link)
                                <div class="alert alert-info mb-4">
                                    <h6><i class="fas fa-link"></i> Custom Link</h6>
                                    <a href="{{ $benefit->custom_link }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                        {{ $benefit->custom_link }} <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>
                                @endif
                                
                                @if($benefit->excerpt)
                                <div class="card bg-light mb-4">
                                    <div class="card-body">
                                        <h5>Excerpt</h5>
                                        <p class="mb-0">{{ $benefit->excerpt }}</p>
                                    </div>
                                </div>
                                @endif

                                <div class="mt-4">
                                    <h5>Content</h5>
                                    <div class="content-preview">
                                        {!! $benefit->content !!}
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h6>Slug</h6>
                                            <p><code>{{ $benefit->slug }}</code></p>
                                        </div>
                                        <div class="col-md-6">
                                            <h6>Sort Order</h6>
                                            <p>{{ $benefit->sort_order }}</p>
                                        </div>
                                    </div>
                                </div>

                                @if($benefit->is_featured)
                                <div class="mt-3">
                                    <span class="badge bg-primary">Featured Benefit</span>
                                </div>
                                @endif

                                <div class="mt-4">
                                    <small class="text-muted">
                                        Created: {{ $benefit->created_at->format('d M Y, h:i A') }} | 
                                        Last Updated: {{ $benefit->updated_at->format('d M Y, h:i A') }}
                                        @if($benefit->author)
                                        | Author: {{ $benefit->author->name }}
                                        @endif
                                        @if($benefit->updatedBy)
                                        | Updated by: {{ $benefit->updatedBy->name }}
                                        @endif
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Meta Information -->
                        @if($benefit->meta_title || $benefit->meta_description || $benefit->meta_keywords)
                        <div class="card mb-4">
                            <div class="card-header">SEO Information</div>
                            <div class="card-body">
                                @if($benefit->meta_title)
                                <div class="mb-3">
                                    <h6>Meta Title</h6>
                                    <p class="mb-0">{{ $benefit->meta_title }}</p>
                                </div>
                                @endif

                                @if($benefit->meta_description)
                                <div class="mb-3">
                                    <h6>Meta Description</h6>
                                    <p class="mb-0">{{ $benefit->meta_description }}</p>
                                </div>
                                @endif

                                @if($benefit->meta_keywords)
                                <div class="mb-3">
                                    <h6>Meta Keywords</h6>
                                    <p class="mb-0">{{ $benefit->meta_keywords }}</p>
                                </div>
                                @endif

                                @if($benefit->meta_robots)
                                <div class="mb-3">
                                    <h6>Meta Robots</h6>
                                    <p class="mb-0">{{ $benefit->meta_robots }}</p>
                                </div>
                                @endif

                                @if($benefit->canonical_url)
                                <div class="mb-3">
                                    <h6>Canonical URL</h6>
                                    <p class="mb-0"><a href="{{ $benefit->canonical_url }}" target="_blank">{{ $benefit->canonical_url }}</a></p>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Publishing Information -->
                        <div class="card">
                            <div class="card-header">Publishing Information</div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <h6>Status</h6>
                                    <span class="badge {{ $benefit->status == 'published' ? 'bg-success' : ($benefit->status == 'draft' ? 'bg-warning' : 'bg-secondary') }}">
                                        {{ ucfirst($benefit->status) }}
                                    </span>
                                </div>

                                @if($benefit->published_at)
                                <div class="mb-3">
                                    <h6>Published Date</h6>
                                    <p class="mb-0">{{ $benefit->published_at->format('d M Y, h:i A') }}</p>
                                </div>
                                @endif

                                <div class="mb-3">
                                    <h6>Sort Order</h6>
                                    <p class="mb-0">{{ $benefit->sort_order }}</p>
                                </div>

                                @if($benefit->is_featured)
                                <div class="mb-3">
                                    <h6>Featured</h6>
                                    <span class="badge bg-primary">Yes</span>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
.content-preview {
    border: 1px solid #e9ecef;
    padding: 1rem;
    border-radius: 0.375rem;
    background-color: #f8f9fa;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
