@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Charities</h1>
                    <a href="{{ route('admin.charities.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Charity
                    </a>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if($charities->isEmpty())
                    <div class="alert alert-info" role="alert">
                        No charities found. Click the "Create Charity" button to add one.
                    </div>
                @else
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Logo</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Sort Order</th>
                                    <th>Featured</th>
                                    <th>Website</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($charities as $charity)
                                    <tr>
                                        <td>
                                            @if($charity->logo && Storage::disk('public')->exists($charity->logo))
                                                <img src="{{ Storage::url($charity->logo) }}" 
                                                     alt="{{ $charity->logo_alt ?? $charity->name }}" 
                                                     class="img-thumbnail" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-light d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="fas fa-heart text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $charity->name }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $charity->slug }}</small>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $charity->status === 'active' ? 'success' : 'secondary' }}">
                                                {{ ucfirst($charity->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $charity->sort_order }}</td>
                                        <td>
                                            @if($charity->is_featured)
                                                <span class="badge bg-warning">Featured</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($charity->website_url)
                                                <a href="{{ $charity->website_url }}" target="_blank" rel="noopener" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-external-link-alt"></i>
                                                </a>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.charities.show', $charity) }}" 
                                                   class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.charities.edit', $charity) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.charities.destroy', $charity) }}" 
                                                      method="POST" 
                                                      class="d-inline"
                                                      onsubmit="return confirm('Are you sure you want to delete this charity?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($charities->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            {{ $charities->links() }}
                        </div>
                    @endif
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
