@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">                
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Home Page Sections</h1>
                    <div class="btn-group">
                        <form action="{{ route('admin.manage-home.toggle-status', $manageHome) }}" 
                              method="POST" class="d-inline">
                            @csrf
                            <button type="submit" 
                                    class="btn {{ $manageHome->status ? 'btn-success' : 'btn-secondary' }}">
                                <i class="fas fa-toggle-{{ $manageHome->status ? 'on' : 'off' }}"></i>
                                {{ $manageHome->status ? 'Active' : 'Inactive' }}
                            </button>
                        </form>
                        <a href="{{ route('homestatic') }}" class="btn btn-outline-primary" target="_blank">
                            <i class="fas fa-eye"></i> Preview Homepage
                        </a>
                    </div>
                </div>

                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.manage-home.update', $manageHome) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <!-- Current Banner Image -->
                            @if($manageHome->banner_img)
                            <div class="mb-3">
                                <label class="form-label">Current Banner Image</label>
                                <div>
                                    <img src="{{ Storage::url($manageHome->banner_img) }}" 
                                         alt="Current Banner" 
                                         class="img-thumbnail" 
                                         style="max-width: 200px;">
                                </div>
                            </div>
                            @endif

                            <!-- Banner Image Upload -->
                            <div class="mb-4">
                                <label for="banner_img" class="form-label">
                                    {{ $manageHome->banner_img ? 'Replace Banner Image' : 'Banner Image' }}
                                </label>
                                <input type="file" 
                                       class="form-control @error('banner_img') is-invalid @enderror" 
                                       id="banner_img" 
                                       name="banner_img" 
                                       accept="image/*">
                                @error('banner_img')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Supported formats: JPEG, PNG, JPG, GIF. Max size: 2MB
                                    {{ $manageHome->banner_img ? ' (Leave empty to keep current image)' : '' }}
                                </small>
                            </div>                            
                            <!-- Section 1 -->
                            <div class="mb-4">
                                <label for="section_1" class="form-label">Benefits Section Heading</label>
                                <textarea class="form-control @error('section_1') is-invalid @enderror" 
                                          id="section_1" 
                                          name="section_1" 
                                          rows="8" 
                                          placeholder="Enter HTML content for section 1">{{ old('section_1', $manageHome->section_1['content'] ?? '') }}</textarea>
                                @error('section_1')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 2 -->
                            <div class="mb-4">
                                <label for="section_2" class="form-label">The LaLiT Rewards Content</label>
                                <textarea class="form-control @error('section_2') is-invalid @enderror" 
                                          id="section_2" 
                                          name="section_2" 
                                          rows="8" 
                                          placeholder="Enter HTML content for The LaLiT Rewards">{{ old('section_2', $manageHome->section_2['content'] ?? '') }}</textarea>
                                @error('section_2')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 3 -->
                            <div class="mb-4">
                                <label for="section_3" class="form-label">Membership Tiers Content</label>
                                <textarea class="form-control @error('section_3') is-invalid @enderror" 
                                          id="section_3" 
                                          name="section_3" 
                                          rows="8" 
                                          placeholder="Enter HTML content for Membership Tiers">{{ old('section_3', $manageHome->section_3['content'] ?? '') }}</textarea>
                                @error('section_3')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 4 -->
                            <div class="mb-4">
                                <label for="section_4" class="form-label">Help & Support Content</label>
                                <textarea class="form-control @error('section_4') is-invalid @enderror" 
                                          id="section_4" 
                                          name="section_4" 
                                          rows="8" 
                                          placeholder="Enter HTML content for Help & Support">{{ old('section_4', $manageHome->section_4['content'] ?? '') }}</textarea>
                                @error('section_4')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Discover The LaLiT Loyalty -->
                            <div class="mb-4">
                                <h5 class="fw-bold mb-3">Discover The LaLiT Loyalty Section</h5>

                                <!-- Current Section 5 Image (if exists) -->
                                @if(isset($manageHome->section_5['image']) && $manageHome->section_5['image'])
                                <div class="mb-3">
                                    <label class="form-label">Current Section Image</label>
                                    <div>
                                        <img src="{{ Storage::url($manageHome->section_5['image']) }}" 
                                             alt="Discover The LaLiT Loyalty Image" 
                                             class="img-thumbnail" 
                                             style="max-width: 200px;">
                                    </div>
                                </div>
                                @endif

                                <!-- Section 5 Image Upload -->
                                <div class="mb-3">
                                    <label for="section_5_image" class="form-label">
                                        {{ isset($manageHome->section_5['image']) ? 'Replace Section Image' : 'Section Image' }}
                                    </label>
                                    <input type="file" 
                                           class="form-control @error('section_5_image') is-invalid @enderror" 
                                           id="section_5_image" 
                                           name="section_5_image" 
                                           accept="image/*">
                                    @error('section_5_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">
                                        Supported formats: JPEG, PNG, JPG, GIF. Max size: 2MB
                                        {{ isset($manageHome->section_5['image']) ? ' (Leave empty to keep current image)' : '' }}
                                    </small>
                                </div>

                                <!-- Section 5 Content -->
                                <div class="mb-3">
                                    <label for="section_5" class="form-label">Section Content</label>
                                    <textarea class="form-control @error('section_5') is-invalid @enderror" 
                                              id="section_5" 
                                              name="section_5" 
                                              rows="8" 
                                              placeholder="Enter HTML content for Discover The LaLiT Loyalty">{{ old('section_5', $manageHome->section_5['content'] ?? '') }}</textarea>
                                    @error('section_5')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           value="1" 
                                           id="status" 
                                           name="status" 
                                           {{ old('status', $manageHome->status) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status">
                                        Active Status
                                    </label>
                                </div>
                            </div>                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Home Sections
                                </button>
                                <button type="reset" class="btn btn-secondary">
                                    <i class="fas fa-undo"></i> Reset Changes
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
@endsection
