@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Home Page Section</h1>
                    <div class="btn-group">
                        <a href="{{ route('admin.manage-home.edit', $manageHome) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.manage-home.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="row">
                    <!-- Left Column - Details -->
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Section Details</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="120">ID:</th>
                                        <td>{{ $manageHome->id }}</td>
                                    </tr>
                                    <tr>
                                        <th>Status:</th>
                                        <td>
                                            <span class="badge {{ $manageHome->status ? 'bg-success' : 'bg-secondary' }}">
                                                {{ $manageHome->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Created:</th>
                                        <td>{{ $manageHome->created_at->format('M d, Y H:i') }}</td>
                                    </tr>
                                    <tr>
                                        <th>Updated:</th>
                                        <td>{{ $manageHome->updated_at->format('M d, Y H:i') }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column - Banner Image -->
                    <div class="col-md-6">
                        @if($manageHome->banner_img)
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">Banner Image</h5>
                                </div>
                                <div class="card-body text-center">
                                    <img src="{{ Storage::url($manageHome->banner_img) }}" 
                                         alt="Banner Image" 
                                         class="img-fluid rounded shadow">
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Sections Content -->
                <div class="row">
                    @for($i = 1; $i <= 5; $i++)
                        @if($manageHome->{"section_$i"})
                            <div class="col-12 mb-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0">Section {{ $i }}</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="content-preview">
                                            {!! $manageHome->{"section_$i"}['content'] ?? '' !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endfor
                </div>

                @if(!$manageHome->section_1 && !$manageHome->section_2 && !$manageHome->section_3 && !$manageHome->section_4 && !$manageHome->section_5)
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        No section content has been added yet.
                    </div>
                @endif

                <!-- Action Buttons -->
                <div class="d-flex gap-2 mt-4">
                    <a href="{{ route('admin.manage-home.edit', $manageHome) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Section
                    </a>
                    
                    <form action="{{ route('admin.manage-home.toggle-status', $manageHome) }}" 
                          method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn {{ $manageHome->status ? 'btn-secondary' : 'btn-success' }}">
                            <i class="fas fa-toggle-{{ $manageHome->status ? 'off' : 'on' }}"></i>
                            {{ $manageHome->status ? 'Deactivate' : 'Activate' }}
                        </button>
                    </form>
                    
                    <form action="{{ route('admin.manage-home.destroy', $manageHome) }}" 
                          method="POST" class="d-inline"
                          onsubmit="return confirm('Are you sure you want to delete this section? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
.content-preview {
    background: #f8f9fa;
    padding: 1rem;
    border-radius: 0.375rem;
    border: 1px solid #dee2e6;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
@endsection
