@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">                
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Package Details</h1>
                    <div class="btn-group">
                        <form action="{{ route('admin.package-details.toggle-status', $packageDetail) }}" 
                              method="POST" class="d-inline">
                            @csrf
                            <button type="submit" 
                                    class="btn {{ $packageDetail->status ? 'btn-success' : 'btn-secondary' }}">
                                <i class="fas fa-toggle-{{ $packageDetail->status ? 'on' : 'off' }}"></i>
                                {{ $packageDetail->status ? 'Active' : 'Inactive' }}
                            </button>
                        </form>
                        <a href="{{ route('package-details') }}" class="btn btn-outline-primary" target="_blank">
                            <i class="fas fa-eye"></i> Preview Package Details
                        </a>
                    </div>
                </div>

                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.package-details.update', $packageDetail) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <!-- Heading -->
                            <div class="mb-4">
                                <label for="heading" class="form-label">Heading <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('heading') is-invalid @enderror" 
                                       id="heading" 
                                       name="heading" 
                                       value="{{ old('heading', $packageDetail->heading) }}" 
                                       required
                                       placeholder="Enter package heading">
                                @error('heading')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Excerpt -->
                            <div class="mb-4">
                                <label for="excerpt" class="form-label">Excerpt</label>
                                <textarea class="form-control @error('excerpt') is-invalid @enderror" 
                                          id="excerpt" 
                                          name="excerpt" 
                                          rows="3" 
                                          placeholder="Enter a short description/excerpt">{{ old('excerpt', $packageDetail->excerpt) }}</textarea>
                                @error('excerpt')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Brief description that appears as a summary.</small>
                            </div>

                            <!-- Link -->
                            <div class="mb-4">
                                <label for="link" class="form-label">Link</label>
                                <input type="url" 
                                       class="form-control @error('link') is-invalid @enderror" 
                                       id="link" 
                                       name="link" 
                                       value="{{ old('link', $packageDetail->link) }}" 
                                       placeholder="https://example.com">
                                @error('link')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Optional link to external page or booking form.</small>
                            </div>

                            <!-- Current Featured Image -->
                            @if($packageDetail->featured_image)
                            <div class="mb-3">
                                <label class="form-label">Current Featured Image</label>
                                <div>
                                    <img src="{{ Storage::url($packageDetail->featured_image) }}" 
                                         alt="Current Featured Image" 
                                         class="img-thumbnail" 
                                         style="max-width: 200px;">
                                </div>
                            </div>
                            @endif

                            <!-- Featured Image Upload -->
                            <div class="mb-4">
                                <label for="featured_image" class="form-label">
                                    {{ $packageDetail->featured_image ? 'Replace Featured Image' : 'Featured Image' }}
                                </label>
                                <input type="file" 
                                       class="form-control @error('featured_image') is-invalid @enderror" 
                                       id="featured_image" 
                                       name="featured_image" 
                                       accept="image/*">
                                @error('featured_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Supported formats: JPEG, PNG, JPG, GIF, WebP. Max size: 2MB
                                    {{ $packageDetail->featured_image ? ' (Leave empty to keep current image)' : '' }}
                                </small>
                            </div>

                            <!-- Current Package Image -->
                            @if($packageDetail->package_image)
                            <div class="mb-3">
                                <label class="form-label">Current Package Image</label>
                                <div>
                                    <img src="{{ Storage::url($packageDetail->package_image) }}" 
                                         alt="Current Package Image" 
                                         class="img-thumbnail" 
                                         style="max-width: 200px;">
                                </div>
                            </div>
                            @endif

                            <!-- Package Image Upload -->
                            <div class="mb-4">
                                <label for="package_image" class="form-label">
                                    {{ $packageDetail->package_image ? 'Replace Package Image' : 'Package Image' }}
                                </label>
                                <input type="file" 
                                       class="form-control @error('package_image') is-invalid @enderror" 
                                       id="package_image" 
                                       name="package_image" 
                                       accept="image/*">
                                @error('package_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Supported formats: JPEG, PNG, JPG, GIF, WebP. Max size: 2MB
                                    {{ $packageDetail->package_image ? ' (Leave empty to keep current image)' : '' }}
                                </small>
                            </div>

                            <!-- Content -->
                            <div class="mb-4">
                                <label for="content" class="form-label">Content</label>
                                <textarea class="form-control @error('content') is-invalid @enderror" 
                                          id="content" 
                                          name="content" 
                                          rows="10" 
                                          placeholder="Enter detailed package content">{{ old('content', $packageDetail->content) }}</textarea>
                                @error('content')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>

                            <hr class="my-4">
                            <h4 class="mb-3">Membership Benefits Section</h4>

                            <!-- Membership Benefits Title -->
                            <div class="mb-4">
                                <label for="membership_benefits_title" class="form-label">Membership Benefits Title</label>
                                <input type="text" 
                                       class="form-control @error('membership_benefits_title') is-invalid @enderror" 
                                       id="membership_benefits_title" 
                                       name="membership_benefits_title" 
                                       value="{{ old('membership_benefits_title', $packageDetail->membership_benefits_title) }}"
                                       placeholder="About Membership Benefits">
                                @error('membership_benefits_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Membership Benefits Content -->
                            <div class="mb-4">
                                <label for="membership_benefits_content" class="form-label">Membership Benefits Content</label>
                                <textarea class="form-control @error('membership_benefits_content') is-invalid @enderror" 
                                          id="membership_benefits_content" 
                                          name="membership_benefits_content" 
                                          rows="10" 
                                          placeholder="Enter membership benefits as HTML list items (<li>)">{{ old('membership_benefits_content', $packageDetail->membership_benefits_content) }}</textarea>
                                @error('membership_benefits_content')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Add benefits as list items. Example: &lt;li&gt;Early check-in&lt;/li&gt;</small>
                            </div>

                            <!-- Membership Benefits Disclaimer -->
                            <div class="mb-4">
                                <label for="membership_benefits_disclaimer" class="form-label">Membership Benefits Disclaimer</label>
                                <textarea class="form-control @error('membership_benefits_disclaimer') is-invalid @enderror" 
                                          id="membership_benefits_disclaimer" 
                                          name="membership_benefits_disclaimer" 
                                          rows="3" 
                                          placeholder="Enter disclaimer text">{{ old('membership_benefits_disclaimer', $packageDetail->membership_benefits_disclaimer) }}</textarea>
                                @error('membership_benefits_disclaimer')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <hr class="my-4">

                            <!-- Status -->
                            <div class="mb-4">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="status" 
                                           name="status" 
                                           value="1" 
                                           {{ old('status', $packageDetail->status) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status">
                                        Active (Show on public pages)
                                    </label>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Package Details
                                </button>
                                <a href="{{ route('admin.package-details.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
