@extends('layouts.pages')

@section('title', $page->seo_title)

@push('styles')
<style>
    /* Custom styles for this page */
    .page-header {
        margin-top: 3rem;
    }
    
    /* Desktop-only top margin */
    @media (min-width: 992px) {
        .page-header {
            margin-top: 7rem;
        }
    }
</style>

<!-- SEO Meta Tags -->
<meta name="description" content="{{ $page->seo_description }}">
@if($page->meta_keywords)
    <meta name="keywords" content="{{ $page->meta_keywords }}">
@endif
<meta name="robots" content="{{ $page->meta_robots ?? 'index,follow' }}">

@if($page->canonical_url)
    <link rel="canonical" href="{{ $page->canonical_url }}">
@endif

<!-- Open Graph Meta Tags -->
@if($page->og_data)
    <meta property="og:title" content="{{ $page->og_data['title'] ?? $page->title }}">
    <meta property="og:description" content="{{ $page->og_data['description'] ?? $page->seo_description }}">
    <meta property="og:type" content="{{ $page->og_data['type'] ?? 'article' }}">
    <meta property="og:url" content="{{ $page->url }}">
    @if(isset($page->og_data['image']))
        <meta property="og:image" content="{{ $page->og_data['image'] }}">
    @elseif($page->featured_image)
        <meta property="og:image" content="{{ $page->featured_image }}">
    @endif
@endif

<!-- Twitter Card Meta Tags -->
@if($page->twitter_data)
    <meta name="twitter:card" content="{{ $page->twitter_data['card'] ?? 'summary' }}">
    <meta name="twitter:title" content="{{ $page->twitter_data['title'] ?? $page->title }}">
    <meta name="twitter:description" content="{{ $page->twitter_data['description'] ?? $page->seo_description }}">
    @if(isset($page->twitter_data['image']))
        <meta name="twitter:image" content="{{ $page->twitter_data['image'] }}">
    @elseif($page->featured_image)
        <meta name="twitter:image" content="{{ $page->featured_image }}">
    @endif
@endif
@endpush

@push('scripts')
<!-- Structured Data -->
@if($page->schema_markup)
    <script type="application/ld+json">
        {!! $page->schema_markup !!}
    </script>
@endif
@endpush

@section('hero')
<!-- Banner Image as Hero Section -->
@if($page->banner_image)
    <div class="hero-banner position-relative">
        <div class="hero-image">
            <img src="{{ $page->banner_image }}" 
                 alt="{{ $page->banner_image_alt ?? 'Banner image' }}" 
                 class="w-100" style="height: 25rem; object-fit: cover;">
        </div>
        <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100" style="background: linear-gradient(135deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0.2) 50%, rgba(0,0,0,0.4) 100%);"></div>
    </div>
@endif
@endsection

@section('content')
<!-- Page Content Section -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">                
              <!-- Page Header -->
                <header class="page-header mb-5">
                    <h1 class="section-title mb-4 text-uppercase">{{ $page->title }}</h1>
                    <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>
                    
                    @if($page->excerpt)
                        <p class="section-subtitle mb-4">{{ $page->excerpt }}</p>
                    @endif
                </header>

                <!-- Featured Image -->
                @if($page->featured_image)
                    <div class="mb-5">
                        <figure class="text-center">
                            <img src="{{ $page->featured_image }}" 
                                 alt="{{ $page->featured_image_alt ?? $page->title }}" 
                                 class="img-fluid rounded shadow">
                            @if($page->featured_image_caption)
                                <figcaption class="mt-3 text-muted fst-italic">
                                    {{ $page->featured_image_caption }}
                                </figcaption>
                            @endif
                        </figure>
                    </div>
                @endif

                <!-- Page Content -->
                <article class="page-content">
                    <div class="content-wrapper" style="font-size: 1.1rem; line-height: 1.6; color: #212322;">
                        {!! $page->content !!}
                    </div>
                </article>
            </div>
        </div>
    </div>
</section>

@endsection
