<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PublicPageController;
use App\Http\Controllers\CharityController;
use App\Http\Controllers\Admin\ManageHomeController;
use App\Http\Controllers\Admin\ArtisanController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\SlideController;
use App\Http\Controllers\Admin\CharityController as AdminCharityController;
use Illuminate\Support\Facades\Route;

// Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/', [PublicPageController::class, 'homestatic'])->name('home');
Route::get('/homestatic', [PublicPageController::class, 'homestatic'])->name('homestatic');
Route::get('/package-details', [PublicPageController::class, 'packageDetails'])->name('package-details');

Route::get('/contact', function () {
    return view('contact');
})->name('contact');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Admin routes
    Route::prefix('admin')->name('admin.')->group(function () {
        // Pages management routes (admin)
        Route::resource('pages', PageController::class);

        // Slides management routes (admin)
        Route::resource('slides', SlideController::class);

        // Manage Home routes (admin)
        Route::get('manage-home', [ManageHomeController::class, 'index'])->name('manage-home.index');
        Route::get('manage-home/{manageHome}/edit', [ManageHomeController::class, 'edit'])->name('manage-home.edit');
        Route::put('manage-home/{manageHome}', [ManageHomeController::class, 'update'])->name('manage-home.update');
        Route::post('manage-home/{manageHome}/toggle-status', [ManageHomeController::class, 'toggleStatus'])
                ->name('manage-home.toggle-status');

        // Package Details routes (admin)
        Route::get('package-details', [\App\Http\Controllers\Admin\PackageDetailController::class, 'index'])->name('package-details.index');
        Route::get('package-details/{packageDetail}/edit', [\App\Http\Controllers\Admin\PackageDetailController::class, 'edit'])->name('package-details.edit');
        Route::put('package-details/{packageDetail}', [\App\Http\Controllers\Admin\PackageDetailController::class, 'update'])->name('package-details.update');
        Route::post('package-details/{packageDetail}/toggle-status', [\App\Http\Controllers\Admin\PackageDetailController::class, 'toggleStatus'])
                ->name('package-details.toggle-status');

        // Rewards management routes (admin)
        Route::resource('rewards', \App\Http\Controllers\Admin\RewardController::class);

        // Benefits management routes (admin)
        Route::resource('benefits', \App\Http\Controllers\Admin\BenefitController::class);

        // Points management routes (admin)
        Route::resource('points', \App\Http\Controllers\Admin\PointController::class);

        // Tiers management routes (admin)
        Route::resource('tiers', \App\Http\Controllers\Admin\TierController::class);

        // Charities management routes (admin)
        Route::resource('charities', AdminCharityController::class);

        // Artisan commands routes (admin)
        Route::get('artisan', [ArtisanController::class, 'index'])->name('artisan.index');
        Route::post('artisan/clear-cache', [ArtisanController::class, 'clearCache'])->name('artisan.clear-cache');
        Route::post('artisan/clear-config', [ArtisanController::class, 'clearConfig'])->name('artisan.clear-config');
        Route::post('artisan/clear-route', [ArtisanController::class, 'clearRoute'])->name('artisan.clear-route');
        Route::post('artisan/clear-view', [ArtisanController::class, 'clearView'])->name('artisan.clear-view');
        Route::post('artisan/clear-all', [ArtisanController::class, 'clearAll'])->name('artisan.clear-all');
        Route::post('artisan/storage-link', [ArtisanController::class, 'storageLink'])->name('artisan.storage-link');
        Route::post('artisan/cache-config', [ArtisanController::class, 'cacheConfig'])->name('artisan.cache-config');
        Route::post('artisan/cache-route', [ArtisanController::class, 'cacheRoute'])->name('artisan.cache-route');
        Route::post('artisan/optimize', [ArtisanController::class, 'optimize'])->name('artisan.optimize');
        Route::post('artisan/migrate', [ArtisanController::class, 'migrate'])->name('artisan.migrate');
    });
});

require __DIR__ . '/auth.php';

Route::get('/public/home', [PublicPageController::class, 'test'])->name('pages.test');
Route::get('/rewards/{slug}', [PublicPageController::class, 'rewards'])->name('pages.rewards');
Route::get('/tiers/{slug}', [PublicPageController::class, 'tiers'])->name('pages.tiers');
Route::get('/points/{slug}', [PublicPageController::class, 'points'])->name('pages.points');
Route::get('/contact', [PublicPageController::class, 'contact'])->name('pages.contact');
Route::get('/charity', [CharityController::class, 'index'])->name('charity.index');
Route::get('/charity/{charity}', [CharityController::class, 'show'])->name('charity.show');

// Public page routes
Route::get('/{slug}', [PublicPageController::class, 'showBySlug'])->name('pages.public');
