<?php $__env->startSection('title', $point->meta_title ?? $point->title); ?>

<?php $__env->startSection('meta_description', $point->meta_description); ?>
<?php $__env->startSection('meta_keywords', $point->meta_keywords); ?>
<?php $__env->startSection('meta_robots', $point->meta_robots); ?>
<?php $__env->startSection('canonical_url', $point->canonical_url); ?>

<?php $__env->startSection('content'); ?>
    <div class="container my-5 pt-4">
        <!-- Header Section -->
        <section class="text-center mb-5 pt-lg-3 pt-md-4">
            <h1 class="display-4 fw-bold" style="margin-top:4rem"><?php echo e($point->title); ?></h1>
            <?php if($point->content): ?>
                <div class="lead mt-3 mb-5 w-75 mx-auto">
                    <?php echo e($point->content); ?>

                </div>
            <?php endif; ?>

            <?php if($point->featured_image && Storage::disk('public')->exists($point->featured_image)): ?>
                <div class="featured-image-container text-center mt-4 mb-5">
                    <img src="<?php echo e(Storage::url($point->featured_image)); ?>" alt="<?php echo e($point->title); ?>"
                        class="img-fluid rounded shadow">
                </div>
            <?php endif; ?>
        </section>

        <!-- Earn Points Section -->
        <section class="earn-points-section py-5 mb-5">
            <div class="row g-4">
                <!-- Hotel Stays Column -->
                <?php if($point->hotel_stays_title != ''): ?>
                    <div class="col-md-4">
                        <div class="earn-points-card text-center p-4 h-100">
                            <div class="icon-wrapper mb-4">
                                <i class="<?php echo e($point->hotel_stays_icon ?? ''); ?> fa-3x"></i>
                            </div>
                            <h3 class="h4 mb-3"><?php echo e($point->hotel_stays_title ?? ''); ?></h3>
                            <?php if($point->hotel_stays_content): ?>
                                <p><?php echo nl2br(e($point->hotel_stays_content)); ?></p>
                            <?php endif; ?>
                            <?php if($point->hotel_stays_link): ?>
                                <div class="mt-3">
                                    <a href="<?php echo e($point->hotel_stays_link); ?>" class="btn btn-lalit" target="_blank"
                                        rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($point->dining_title != ''): ?>
                    <!-- Dining Column -->
                    <div class="<?php if(request()->is('points/donate-points')): ?> col-md-12 <?php else: ?> col-md-4 <?php endif; ?>">
                        <div class="earn-points-card text-center p-4 h-100">
                            <?php if($point->dining_icon): ?>
                                <div class="icon-wrapper mb-4">
                                    <i class="<?php echo e($point->dining_icon); ?> fa-3x"></i>
                                </div>
                            <?php endif; ?>
                            <h3 class="h4 mb-3"><?php echo e($point->dining_title ?? ''); ?></h3>
                            <?php if($point->dining_content): ?>
                                <p><?php echo nl2br(e($point->dining_content)); ?></p>
                            <?php endif; ?>
                            <?php if($point->dining_link): ?>
                                <div class="mt-3">
                                    <a href="<?php echo e($point->dining_link); ?>" class="btn btn-lalit" target="_blank"
                                        rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($point->spa_title != ''): ?>
                    <!-- Spa Column -->
                    <div class="col-md-4">
                        <div class="earn-points-card text-center p-4 h-100">
                            <div class="icon-wrapper mb-4">
                                <i class="<?php echo e($point->spa_icon ?? ''); ?> fa-3x"></i>
                            </div>
                            <h3 class="h4 mb-3"><?php echo e($point->spa_title ?? ''); ?></h3>
                            <?php if($point->spa_content): ?>
                                <p><?php echo nl2br(e($point->spa_content)); ?></p>
                            <?php endif; ?>
                            <?php if($point->spa_link): ?>
                                <div class="mt-3">
                                    <a href="<?php echo e($point->spa_link); ?>" class="btn btn-lalit" target="_blank" rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Centered Learn More Link - Only visible for donate-points -->
            <?php if(request()->is('points/donate-points')): ?>
                <div class="text-center mt-5">
                    <a href="<?php echo e(route('charity.index')); ?>" class="btn ct-btn-white btn-lg">
                        Discover More <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            <?php endif; ?>
        </section>

        <!-- Points Earning Image Section -->
        <?php if($point->points_earning_image && Storage::disk('public')->exists($point->points_earning_image)): ?>
            <section class="points-earning-image-section text-center mb-5">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <img src="<?php echo e(Storage::url($point->points_earning_image)); ?>"
                            alt="<?php echo e($point->points_earning_image_alt ?? 'Points Earning Information'); ?>"
                            class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </section>
        <?php endif; ?>

    </div>

    <style>
        /* Featured Image Container - Center Image */
        .featured-image-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .featured-image-container img {
            max-width: 80%;
            max-height: 400px;
            object-fit: cover;
            display: block;
            margin: 0 auto;
        }

        /* Earn Points Section Styles */
        .earn-points-section {
            background-color: #f8f9fa;
            border-radius: 8px;
        }

        .earn-points-card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .earn-points-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .icon-wrapper {
            height: 80px;
            width: 80px;
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f5f0eb;
            border-radius: 50%;
            color: #b18645;
        }

        .header-title-line {
            width: 5.875rem;
        }

        /* Points Earning Image Section */
        .points-earning-image-section img {
            max-width: 100%;
            height: auto;
            transition: transform 0.3s ease;
        }

        .points-earning-image-section img:hover {
            transform: scale(1.02);
        }
    </style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/points.blade.php ENDPATH**/ ?>